/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.component;

import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.translation.LocalizedString;
import org.springframework.util.Assert;

public class ContextVariable<T> {
    public static final String PREFIX = "context:";
    private String id;
    private LocalizedString name;
    private LocalizedString description;
    private Type<T> type;

    public ContextVariable(String id, LocalizedString name, LocalizedString description, Type<T> type) {
        Assert.hasText((String)id, (String)"Id must not be null");
        Assert.isTrue((!id.startsWith(PREFIX) ? 1 : 0) != 0, (String)"Id cannot start with context:");
        Assert.notNull(type, (String)"Type must not be null");
        this.id = PREFIX + id;
        this.name = name == null ? name : LocalizedString.of(id);
        this.type = type;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public Type<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.name.get();
    }

    public String getDescription() {
        return LocalizedString.getOrEmpty(this.description);
    }
}

