/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.google.common.collect.Lists;
import com.suncode.pwfl.component.ParameterDefinition;
import com.suncode.pwfl.core.type.ArrayType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.TypedValue;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Argument {
    private final ParameterDefinition<?> parameter;
    private final TypedValue<?> value;
    private final TypedValue<?>[] values;
    private final boolean array;
    private boolean[] flattenIndexes;

    public Argument(TypedValue<?> value, ParameterDefinition<?> parameter) {
        Assert.notNull(value);
        Assert.notNull(parameter);
        Assert.isTrue((!(parameter.getType() instanceof ArrayType) ? 1 : 0) != 0);
        Assert.isTrue((boolean)value.isInstanceOf(parameter.getType()), (String)("Parameter " + parameter.toString() + " has assigned invalid value with incompatible type."));
        this.array = false;
        this.values = null;
        this.value = value;
        this.parameter = parameter;
    }

    public Argument(TypedValue<?>[] arrayValue, ParameterDefinition<?> parameter) {
        Assert.notNull(arrayValue);
        Assert.notNull(parameter);
        Assert.isTrue((boolean)(parameter.getType() instanceof ArrayType));
        ArrayType type = (ArrayType)parameter.getType();
        this.flattenIndexes = new boolean[arrayValue.length];
        for (int i = 0; i < arrayValue.length; ++i) {
            TypedValue value = arrayValue[i];
            if (type.equals(value.getEvaluableType())) {
                this.flattenIndexes[i] = true;
                continue;
            }
            Assert.isTrue((boolean)value.isInstanceOf(type.getElementType()));
        }
        this.array = true;
        this.values = arrayValue;
        this.value = null;
        this.parameter = parameter;
    }

    public ParameterDefinition<?> getParameter() {
        return this.parameter;
    }

    public boolean matches(Type<?> parameterType) {
        return this.parameter.getType().equals(parameterType);
    }

    public Object get() {
        return this.get(this.parameter.getType().javaType());
    }

    public <T> T get(Class<T> targetClass) {
        if (this.array) {
            ArrayType type = (ArrayType)this.parameter.getType();
            ArrayList result = Lists.newArrayList();
            for (int i = 0; i < this.values.length; ++i) {
                if (this.flattenIndexes[i]) {
                    this.addFlattenValue(result, this.values[i]);
                    continue;
                }
                result.add(this.values[i].getEvaluatedValue(type.getElementType().javaType()));
            }
            return type.readAs(result.toArray(), targetClass);
        }
        return this.value.getEvaluatedValue(targetClass);
    }

    private void addFlattenValue(List<Object> result, TypedValue<?> value) {
        for (Object item : (Object[])value.getEvaluatedValue()) {
            result.add(item);
        }
    }

    public String toString() {
        return this.parameter + "=" + String.valueOf(this.array ? this.values : this.value);
    }

    public static Argument wrap(Object parameterValue, ParameterDefinition<?> parameter) {
        Type<?> type = parameter.getType();
        if (ObjectUtils.isArray((Object)parameterValue)) {
            if (!(type instanceof ArrayType)) {
                throw new IllegalArgumentException("Parameter is not an ArrayType but array parameter value was provided");
            }
            return Argument.wrapArray((Object[])parameterValue, ((ArrayType)type).getElementType(), parameter);
        }
        TypedValue<?> value = Argument.newTypedValue(parameterValue, type);
        return new Argument(value, parameter);
    }

    private static Argument wrapArray(Object[] values, Type<?> elementType, ParameterDefinition<?> parameter) {
        TypedValue[] typedValues = new TypedValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            typedValues[i] = Argument.newTypedValue(values[i], elementType);
        }
        return new Argument(typedValues, parameter);
    }

    private static TypedValue<?> newTypedValue(Object value, Type<?> type) {
        if (value instanceof TypedValue) {
            return (TypedValue)value;
        }
        return value == null ? TypedValue.nullValue(type) : new TypedValue<Object>(value);
    }
}

