/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.translation;

import com.suncode.pwfl.translation.EmptyTranslator;
import com.suncode.pwfl.translation.NoTranslationException;
import com.suncode.pwfl.translation.Translator;
import java.util.Locale;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.util.Assert;

public class LocalizedString {
    private final String key;
    private final String defaultValue;
    private final Translator translator;
    private final Locale locale;
    private final Object[] args;

    public LocalizedString(String key, Translator translator, Object ... args) {
        this(key, key, translator, null, args);
    }

    public LocalizedString(String key, String defaultValue, Translator translator, Locale locale, Object ... args) {
        Assert.hasText((String)key);
        Assert.notNull((Object)translator);
        this.key = key;
        this.defaultValue = defaultValue;
        this.translator = translator;
        this.locale = locale;
        this.args = args != null ? args : new Object[]{};
    }

    public static LocalizedString of(String value) {
        if (value == null) {
            return null;
        }
        return new LocalizedString(value, EmptyTranslator.INSTANCE, new Object[0]);
    }

    public String get() throws NoTranslationException {
        try {
            return this.translator.getMessage(this.key, this.locale, this.args);
        }
        catch (NoTranslationException e) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw e;
        }
    }

    public String getOptional() {
        try {
            return this.get();
        }
        catch (NoTranslationException e) {
            return this.key;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LocalizedString) {
            LocalizedString other = (LocalizedString)obj;
            return new EqualsBuilder().append((Object)this.key, (Object)other.key).append((Object)this.defaultValue, (Object)other.defaultValue).append((Object)this.translator, (Object)other.translator).append((Object)this.locale, (Object)other.locale).append(this.args, other.args).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.defaultValue).append((Object)this.translator).append((Object)this.locale).append(this.args).toHashCode();
    }

    public String toString() {
        return "LocalizedString(" + this.key + ")";
    }
}

