/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.field;

import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.workflow.form.AbstractFormField;
import com.suncode.pwfl.workflow.form.FieldType;
import java.util.ArrayList;
import java.util.List;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleUsers
extends AbstractFormField {
    private static final Logger log = LoggerFactory.getLogger(RoleUsers.class);
    private List<String> roleIds = new ArrayList<String>();
    private List<String> ouNames = new ArrayList<String>();

    public RoleUsers() {
        this.type = FieldType.RoleUsers;
    }

    @Override
    public void readSpecificAttribute(ExtendedAttribute attr) {
        String attrValue = attr.getVValue();
        log.debug("Attribute value: {}", (Object)attrValue);
        String[] split = attrValue.split("\n");
        this.readData(split);
    }

    private void readData(String[] split) {
        for (int i = 1; i < split.length; ++i) {
            String[] line = split[i].split("=");
            String param = line[0];
            String value = line[1];
            if (param.equalsIgnoreCase("role")) {
                this.roleIds.add(value);
                continue;
            }
            if (param.equalsIgnoreCase("ou")) {
                this.ouNames.add(value);
                continue;
            }
            throw new ServiceException("Pole typu ROLEUSERS musi posiada\u0107 wiersze postaci role=<id_roli> lub ou=<nazwa_ou>. B\u0142\u0105d w lini: " + split[i]);
        }
    }

    public List<String> getRoleIds() {
        return this.roleIds;
    }

    public void setRoleIds(List<String> roleIds) {
        this.roleIds = roleIds;
    }

    public List<String> getOuNames() {
        return this.ouNames;
    }

    public void setOuNames(List<String> ouNames) {
        this.ouNames = ouNames;
    }
}

