/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.archive.DocumentClassAction;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.exception.IllegalExpirationTypeException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="pm_docclasses")
@SequenceGenerator(name="pm_docclasses_id_seq", sequenceName="pm_docclasses_id_seq")
public class DocumentClass {
    public static final String JOIN_DEVICE = "directory.device";
    public static final String JOIN_DIRECTORY = "directory";
    public static final String JOIN_INDEXES = "indexes";
    public static final String JOIN_ACTIONS = "actions";
    public static final String JOIN_FILES = "files";
    private Long id;
    private String name;
    private String description;
    private String expiration;
    private String expirationType;
    private Directory directory;
    private boolean encoding;
    private boolean compressing;
    private Long ftsServerId;
    private String cipherAlgorithm;
    private Long keyLength;
    private Long orderId;
    private String indexPath;
    private boolean indexing;
    private Set<WfFile> files;
    private Set<DocumentClassAction> actions;
    private Set<DocumentClassIndex> indexes;
    private Set<LinkConnection> linkConnections;

    public DocumentClass() {
    }

    public DocumentClass(Long docClassId) {
        this.id = docClassId;
    }

    @Column(name="docclasscompressing")
    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    @Column(name="docclassindex")
    public boolean isIndexing() {
        return this.indexing;
    }

    public void setIndexing(boolean indexing) {
        this.indexing = indexing;
    }

    @Column(name="docclassexpiretiondate")
    public String getExpiration() {
        return this.expiration;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    @Column(name="docclassexpiretiontype")
    public String getExpirationType() {
        return this.expirationType;
    }

    public void setExpirationType(String expirationType) {
        this.expirationType = expirationType;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="docclassdirectoryid", nullable=false)
    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    @Column(name="docclassencoding")
    public boolean isEncoding() {
        return this.encoding;
    }

    public void setEncoding(boolean encoding) {
        this.encoding = encoding;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public Long getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(Long keyLength) {
        this.keyLength = keyLength;
    }

    @Column(name="docclassorderid")
    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    @Column(name="docclassindexpath")
    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="documentClass", cascade={CascadeType.ALL})
    public Set<DocumentClassAction> getActions() {
        if (this.actions == null) {
            return new HashSet<DocumentClassAction>();
        }
        return this.actions;
    }

    public void setActions(Set<DocumentClassAction> actions) {
        this.actions = actions;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="documentClass", cascade={CascadeType.ALL})
    public Set<DocumentClassIndex> getIndexes() {
        if (this.indexes == null) {
            this.indexes = new HashSet<DocumentClassIndex>();
        }
        return this.indexes;
    }

    public void setIndexes(Set<DocumentClassIndex> indexes) {
        this.indexes = indexes;
    }

    @Id
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_docclasses_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="docclassname", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="docclassdescription")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="documentClass")
    public Set<WfFile> getFiles() {
        return this.files;
    }

    public void setFiles(Set<WfFile> files) {
        this.files = files;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="documentClass")
    public Set<LinkConnection> getLinkConnections() {
        return this.linkConnections;
    }

    public void setLinkConnections(Set<LinkConnection> linkConnections) {
        this.linkConnections = linkConnections;
    }

    public void addIndex(DocumentClassIndex index) {
        this.getIndexes().add(index);
    }

    public void addAction(DocumentClassAction action) {
        this.getActions().add(action);
    }

    @Transient
    public Date getExpirationDate() throws ParseException, IllegalExpirationTypeException {
        if (this.expirationType == null || StringUtils.isBlank((String)this.expiration)) {
            return null;
        }
        if (this.expirationType.equals("endDay")) {
            return new SimpleDateFormat("y-M-d").parse(this.expiration);
        }
        if (this.expirationType.equals("period") || this.expirationType.equals("dayCnt")) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, Integer.valueOf(this.expiration));
            return c.getTime();
        }
        return null;
    }

    @Column(name="docclassftsserverid")
    public Long getFtsServerId() {
        return this.ftsServerId;
    }

    public void setFtsServerId(Long ftsServerId) {
        this.ftsServerId = ftsServerId;
    }
}

