/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class SystemVersion {
    private static final Logger logger = LoggerFactory.getLogger(SystemVersion.class);
    private static final Properties versionProperties = new Properties();

    public static String getVersion() {
        return versionProperties.getProperty("version");
    }

    public static String getDate() {
        return versionProperties.getProperty("buildDate").substring(6);
    }

    public static String getRevision() {
        return versionProperties.getProperty("revision");
    }

    public static String getVersionIdentifier() {
        String rev = SystemVersion.getRevision();
        String ver = SystemVersion.getVersion();
        if (StringUtils.hasText((String)ver)) {
            return ver + (StringUtils.hasText((String)rev) ? " (#" + rev + ")" : "");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassPathResource version = new ClassPathResource("workflow-version.properties");
        InputStream inputStream = null;
        try {
            inputStream = version.getInputStream();
            versionProperties.load(inputStream);
        }
        catch (IOException e) {
            logger.error("Could not read PlusWorkflow version properties file [" + version + "]", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

