/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.search.hibernate;

import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.FilterOperatorNotSupported;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class RestrictionBuilder {
    public static Criterion buildRestriction(String property, Object value, FilterOperator operator) {
        if (operator == FilterOperator.EQ) {
            return Restrictions.eq((String)property, (Object)value);
        }
        if (operator == FilterOperator.LIKE) {
            return Restrictions.like((String)property, (Object)value);
        }
        if (operator == FilterOperator.NOTLIKE) {
            return Restrictions.not((Criterion)Restrictions.like((String)property, (Object)value));
        }
        if (operator == FilterOperator.NOTEQ) {
            return Restrictions.ne((String)property, (Object)value);
        }
        if (operator == FilterOperator.BETWEEN) {
            Object v1 = null;
            Object v2 = null;
            if (value instanceof Object[]) {
                Object[] val = (Object[])value;
                v1 = val[0];
                v2 = val[1];
                return Restrictions.between((String)property, (Object)val[0], (Object)val[1]);
            }
            if (value instanceof List) {
                List val = (List)value;
                v1 = val.get(0);
                v2 = val.get(1);
            }
            if (v1 == null) {
                return RestrictionBuilder.buildRestriction(property, v2, FilterOperator.LT);
            }
            if (v2 == null) {
                return RestrictionBuilder.buildRestriction(property, v1, FilterOperator.GT);
            }
            return Restrictions.between((String)property, (Object)v1, v2);
        }
        if (operator == FilterOperator.ISNULL) {
            return Restrictions.isNull((String)property);
        }
        if (operator == FilterOperator.NOTNULL) {
            return Restrictions.isNotNull((String)property);
        }
        if (operator == FilterOperator.IN) {
            if (value instanceof Object[]) {
                return Restrictions.in((String)property, (Object[])((Object[])value));
            }
            if (value instanceof List) {
                return Restrictions.in((String)property, (Collection)((List)value));
            }
        } else if (operator == FilterOperator.NOTIN) {
            if (value instanceof Object[]) {
                return Restrictions.not((Criterion)Restrictions.in((String)property, (Object[])((Object[])value)));
            }
            if (value instanceof List) {
                return Restrictions.not((Criterion)Restrictions.in((String)property, (Collection)((List)value)));
            }
        } else {
            if (operator == FilterOperator.GT) {
                return Restrictions.gt((String)property, (Object)value);
            }
            if (operator == FilterOperator.LT) {
                return Restrictions.lt((String)property, (Object)value);
            }
            if (operator == FilterOperator.GE) {
                return Restrictions.ge((String)property, (Object)value);
            }
            if (operator == FilterOperator.LE) {
                return Restrictions.le((String)property, (Object)value);
            }
        }
        throw new FilterOperatorNotSupported(operator.toString());
    }
}

