/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.substitution;

import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.substitution.Substitution;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstitutionDto {
    private Logger log = LoggerFactory.getLogger(SubstitutionDto.class);
    private Long id;
    private String processDefName;
    private String roleName;
    private String substitutedFullName;
    private String substituteFullName;
    private String startDate;
    private String finishDate;
    private boolean admin = false;

    public SubstitutionDto(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProcessDefName() {
        return this.processDefName;
    }

    public void setProcessDefName(String processDefId) {
        if (processDefId == null) {
            this.processDefName = MessageHelper.getMessage((String)"Wszystkie");
        } else {
            ProcessService ps = ServiceFactory.getProcessService();
            ProcessDefinition pd = ps.getProcessDefinition(processDefId);
            if (pd != null) {
                this.processDefName = PackageTranslationHelper.getProcessName((String)pd.getPackageId(), (String)pd.getProcessDefinitionId());
            } else {
                this.log.warn("Zast\u0119pstwo jest ustawione na proces '{}', kt\u00f3ry nie istnieje. Prawdopodobnie pakiet z tym procesem zosta\u0142 ca\u0142kowicie wy\u0142adowany.", (Object)processDefId);
                this.processDefName = processDefId;
            }
        }
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(Role role) {
        this.roleName = role == null ? MessageHelper.getMessage((String)"Wszyscy") : role.getRoleName();
    }

    public String getSubstitutedFullName() {
        return this.substitutedFullName;
    }

    public void setSubstitutedFullName(User substituted) {
        this.substitutedFullName = substituted.getFullName();
    }

    public String getSubstituteFullName() {
        return this.substituteFullName;
    }

    public void setSubstituteFullName(User substituteFullName) {
        this.substituteFullName = substituteFullName.getFullName();
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDateTime startDate) {
        String date = "*";
        if (!startDate.toLocalDate().equals((Object)new LocalDate((Object)"1970-01-01"))) {
            date = startDate.toLocalDate().toString();
        }
        this.startDate = date;
    }

    public String getFinishDate() {
        return this.finishDate;
    }

    public void setFinishDate(LocalDateTime finishDate) {
        String date = "*";
        if (finishDate != null) {
            date = finishDate.toLocalDate().toString();
        }
        this.finishDate = date;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public static List<SubstitutionDto> build(List<Substitution> substitutions) {
        ArrayList<SubstitutionDto> substitutionsDto = new ArrayList<SubstitutionDto>();
        for (Substitution substitution : substitutions) {
            SubstitutionDto wrapper = new SubstitutionDto(substitution.getId());
            wrapper.setProcessDefName(substitution.getProcessDefId());
            wrapper.setRoleName(substitution.getRole());
            wrapper.setSubstitutedFullName(substitution.getSubstituted());
            wrapper.setSubstituteFullName(substitution.getSubstitute());
            wrapper.setStartDate(substitution.getStartDate());
            wrapper.setFinishDate(substitution.getFinishDate());
            wrapper.setAdmin(true);
            substitutionsDto.add(wrapper);
        }
        return substitutionsDto;
    }
}

