/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.search.sql;

import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLQueryBuilder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.type.Type;

public class SQLBuilder {
    private String query;
    private String buildedQuery;
    private boolean useScalars = true;
    private String countQuery;
    private Map<String, Type> scalars = new HashMap<String, Type>();
    private List<SQLFilter> filters = new ArrayList<SQLFilter>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private List<Sorter> sorters = new ArrayList<Sorter>();

    public SQLBuilder() {
    }

    public SQLBuilder(String query) {
        this.query = query;
    }

    public SQLBuilder(String query, Map<String, Type> scalars, List<SQLFilter> filters) {
        this.query = query;
        this.scalars = scalars;
        this.filters = filters;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isUseScalars() {
        return this.useScalars;
    }

    public void setUseScalars(boolean useScalars) {
        this.useScalars = useScalars;
    }

    public Map<String, Type> getScalars() {
        return this.scalars;
    }

    public void setScalars(Map<String, Type> scalars) {
        this.scalars = scalars;
    }

    public List<SQLFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SQLFilter> filters) {
        this.filters = filters;
    }

    public void setFilters(Map<String, Object> params) {
        for (String alias : params.keySet()) {
            SimpleSQLFilter filter = new SimpleSQLFilter(alias, params.get(alias));
            this.filters.add(filter);
        }
    }

    public void addScalar(String alias, Type type) {
        this.scalars.put(alias, type);
    }

    public List<Sorter> getSorters() {
        return this.sorters;
    }

    public void setSorters(List<Sorter> sorters) {
        this.sorters = sorters;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String alias, Object value) {
        this.parameters.put(alias, value);
    }

    public void addFilter(SQLFilter filter) {
        this.filters.add(filter);
    }

    public void setParameters(List<SQLFilter> filters) {
        for (SQLFilter sqlFilter : filters) {
            sqlFilter.setFilterValue(this.parameters);
        }
    }

    public void addSorter(Sorter sorter) {
        this.sorters.add(sorter);
    }

    public String buildQuery() {
        StringBuilder query = new StringBuilder(this.getQuery());
        this.buildFilters(query, this.getFilters());
        this.buildOrder(query, this.getSorters());
        this.buildedQuery = query.toString();
        return this.buildedQuery;
    }

    public String buildQuery(String baseQuery) {
        StringBuilder query = new StringBuilder(baseQuery);
        this.buildFilters(query, this.getFilters());
        this.buildOrder(query, this.getSorters());
        return query.toString();
    }

    private void buildOrder(StringBuilder query, List<Sorter> sorters) {
        if (sorters != null && !sorters.isEmpty()) {
            query.append(" order by ");
        }
        SQLQueryBuilder.buildOrder(query, sorters);
    }

    private void buildFilters(StringBuilder query, List<SQLFilter> filters) {
        if (filters != null && !filters.isEmpty()) {
            query.append(" where ");
        }
        SQLQueryBuilder.buildWhere(query, filters);
    }

    public String getCountQuery() {
        if (this.countQuery == null) {
            this.countQuery = "select count(*) as cnt from (" + this.getBuildedQuery() + ") as data ";
        }
        return this.countQuery;
    }

    public void setCountQuery(String countQuery) {
        this.countQuery = countQuery;
    }

    private String getBuildedQuery() {
        if (this.buildedQuery == null) {
            this.buildedQuery = this.buildQuery();
        }
        return this.buildedQuery;
    }
}

