/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="pm_file_versions")
@SequenceGenerator(name="file_versions_file_id_seq", sequenceName="file_versions_file_id_seq")
public class WfFileVersion {
    private WfFile file;
    private WfFile parentFile;
    private WfFile newestFile;
    private Date checkOutDate;
    private Date checkInDate;
    private Date replaceDate;
    private String checkOutUserName;
    private String state;
    private String comment;
    private int version;
    private Long id;
    private Set<ActivityDocument> activityDocuments;

    public WfFileVersion() {
    }

    public WfFileVersion(WfFile file) {
        this.checkInDate = new Date();
        this.file = file;
        this.newestFile = file;
        this.state = State.STATE_READY.toString();
        this.version = 1;
    }

    public WfFileVersion(WfFile file, String uploader) {
        this.checkInDate = new Date();
        this.file = file;
        this.newestFile = file;
        this.checkOutUserName = uploader;
        this.state = State.STATE_READY.toString();
        this.version = 1;
    }

    @Fetch(value=FetchMode.JOIN)
    @OneToOne
    @JoinColumn(name="fileid")
    public WfFile getFile() {
        return this.file;
    }

    public void setFile(WfFile file) {
        this.file = file;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name="file_comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="replace_date")
    public Date getReplaceDate() {
        return this.replaceDate;
    }

    public void setReplaceDate(Date replaceDate) {
        this.replaceDate = replaceDate;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_fileid")
    public WfFile getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(WfFile parentFile) {
        this.parentFile = parentFile;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="newest_fileid")
    public WfFile getNewestFile() {
        return this.newestFile;
    }

    public void setNewestFile(WfFile newestFile) {
        this.newestFile = newestFile;
    }

    @Column(name="checkout_date")
    public Date getCheckOutDate() {
        return this.checkOutDate;
    }

    public void setCheckOutDate(Date checkOutDate) {
        this.checkOutDate = checkOutDate;
    }

    @Column(name="checkin_date")
    public Date getCheckInDate() {
        return this.checkInDate;
    }

    public void setCheckInDate(Date checkInDate) {
        this.checkInDate = checkInDate;
    }

    @Column(name="checkout_user")
    public String getCheckOutUserName() {
        return this.checkOutUserName;
    }

    public void setCheckOutUserName(String checkOutUserName) {
        this.checkOutUserName = checkOutUserName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="file_versions_file_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @OneToMany(mappedBy="version", cascade={CascadeType.ALL})
    public Set<ActivityDocument> getActivityDocuments() {
        return this.activityDocuments;
    }

    public void setActivityDocuments(Set<ActivityDocument> activityDocuments) {
        this.activityDocuments = activityDocuments;
    }

    public static enum State {
        STATE_READY,
        STATE_EDIT;

    }
}

