/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.UserGroup;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class User {
    public static final String JOIN_GROUPS = "groups";
    public static final String JOIN_POSITIONS = "positions";
    public static final String JOIN_OU = "positions.organizationalUnit";
    private String userName;
    private Long objectId;
    private String firstName;
    private String lastName;
    private String password;
    private String email;
    private Boolean active;
    private String number;
    private Set<Position> positions = new HashSet<Position>();
    private Set<UserGroup> groups = new HashSet<UserGroup>();

    User() {
    }

    public User(String userName, String password) {
        this.setUserName(userName);
        this.setPassword(password);
    }

    public Set<UserGroup> getGroups() {
        return this.groups;
    }

    void setGroups(Set<UserGroup> groups) {
        this.groups = groups;
    }

    void addGroup(UserGroup ug) {
        this.groups.add(ug);
    }

    void addGroup(String groupName) {
        UserGroup ug = new UserGroup(groupName);
        this.groups.add(ug);
    }

    public String getUserName() {
        return this.userName;
    }

    void setUserName(String userName) {
        if (StringUtils.isBlank((String)userName)) {
            throw new IllegalArgumentException("Login u\u017cytkownika nie mo\u017ce by\u0107 pusty");
        }
        this.userName = userName;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullName() {
        return StringUtils.trimToEmpty((String)this.getFirstName()) + " " + StringUtils.trimToEmpty((String)this.getLastName());
    }

    public Set<Position> getPositions() {
        return this.positions;
    }

    void setPositions(Set<Position> positions) {
        this.positions = positions;
    }

    public Boolean isActive() {
        return this.active;
    }

    void setActive(Boolean active) {
        this.active = active;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
}

