/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.support;

import com.suncode.pwfl.support.BaseDao;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public abstract class HibernateBaseDao<T, PK extends Serializable>
implements BaseDao<T, PK> {
    protected Class<?> type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Session getSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    @Override
    public List<T> findByCriteria(DetachedCriteria dc) {
        return dc.getExecutableCriteria(this.getSession()).list();
    }

    @Override
    public List<T> findByCriteria(DetachedCriteria dc, Integer start, Integer limit) {
        Criteria crit = dc.getExecutableCriteria(this.getSession());
        if (limit != null) {
            crit.setMaxResults(limit.intValue());
        }
        if (start != null) {
            crit.setFirstResult(start.intValue());
        }
        return crit.list();
    }

    @Override
    public T get(PK id) {
        return (T)this.getSession().get(this.type, id);
    }

    @Override
    public List<T> getAll(String ... joins) {
        Criteria crit = this.getSession().createCriteria(this.type);
        for (String join : joins) {
            crit.setFetchMode(join, FetchMode.JOIN);
        }
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    @Override
    public List<T> getAll(int start, int limit, String ... joins) {
        Criteria crit = this.getSession().createCriteria(this.type);
        for (String join : joins) {
            crit.setFetchMode(join, FetchMode.JOIN);
        }
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return crit.setMaxResults(limit).setFirstResult(start).list();
    }

    @Override
    public T get(PK id, String ... joins) {
        if (joins.length == 0) {
            return this.get(id);
        }
        DetachedCriteria dc = DetachedCriteria.forClass(this.type);
        dc.add(Restrictions.idEq(id));
        for (String join : joins) {
            dc.setFetchMode(join, FetchMode.JOIN);
        }
        List<T> list = this.findByCriteria(dc);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public T getByField(String field, Object value, String ... joins) {
        DetachedCriteria dc = DetachedCriteria.forClass(this.type);
        dc.add((Criterion)Restrictions.eq((String)field, (Object)value));
        for (String join : joins) {
            dc.setFetchMode(join, FetchMode.JOIN);
        }
        List<T> list = this.findByCriteria(dc);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public long countByCriteria(DetachedCriteria dc) {
        dc.setProjection(Projections.rowCount());
        long count = (Long)dc.getExecutableCriteria(this.getSession()).uniqueResult();
        return count;
    }

    @Override
    public long countAll() {
        return this.countByCriteria(DetachedCriteria.forClass(this.type));
    }

    @Override
    public T findOneByProperty(String property, Object value, String ... joins) {
        List<T> list = this.findByProperty(property, value, null, null, joins);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<T> findByProperty(String property, Object value, Integer start, Integer limit, String ... joins) {
        DetachedCriteria dc = DetachedCriteria.forClass(this.type);
        dc.add((Criterion)Restrictions.eq((String)property, (Object)value));
        for (String join : joins) {
            dc.setFetchMode(join, FetchMode.JOIN);
        }
        return this.findByCriteria(dc, start, limit);
    }

    @Override
    public T findOne(DetachedCriteria dc) {
        List<T> list = this.findByCriteria(dc, 0, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public String[] propertyList() {
        return this.sessionFactory.getClassMetadata(this.type).getPropertyNames();
    }
}

