/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="pm_directories")
@SequenceGenerator(name="pm_directories_id_seq", sequenceName="pm_directories_id_seq")
public class Directory {
    public static final String JOIN_DOC_CLASSES = "docClasses";
    public static final String JOIN_DEVICE = "device";
    public static final String JOIN_ROOT_DIR = "rootDir";
    private Long id;
    private Directory rootDir;
    private Device device;
    private String directoryName;
    private Long directorySize;
    private Long directoryThreshold;
    private Long directoryFreeSpace;
    private Set<DocumentClass> docClasses;

    public Directory(Long id) {
        this.id = id;
    }

    public Directory() {
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_directories_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rootdirectoryid")
    public Directory getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(Directory rootDir) {
        this.rootDir = rootDir;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="deviceid")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String name) {
        this.directoryName = name;
    }

    public Long getDirectorySize() {
        return this.directorySize;
    }

    public void setDirectorySize(Long size) {
        this.directorySize = size;
    }

    public Long getDirectoryThreshold() {
        return this.directoryThreshold;
    }

    public void setDirectoryThreshold(Long treshold) {
        this.directoryThreshold = treshold;
    }

    public Long getDirectoryFreeSpace() {
        return this.directoryFreeSpace;
    }

    public void setDirectoryFreeSpace(Long freeSpace) {
        this.directoryFreeSpace = freeSpace;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="directory")
    public Set<DocumentClass> getDocClasses() {
        return this.docClasses;
    }

    public void setDocClasses(Set<DocumentClass> docClasses) {
        this.docClasses = docClasses;
    }

    @Transient
    @JsonIgnore
    public Long getTrueDirectoryFreeSpace() {
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        String path = as.getDirectoryPath(this);
        File dir = new File(path);
        long lDirectoryFreeSpace = this.size(dir);
        lDirectoryFreeSpace = lDirectoryFreeSpace / 1024L / 1024L;
        this.directoryFreeSpace = this.directorySize - lDirectoryFreeSpace;
        return this.directoryFreeSpace;
    }

    @Transient
    public long size(File file) {
        if (file.isFile()) {
            return file.length();
        }
        File[] files = file.listFiles();
        long size = 0L;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                size += this.size(files[i]);
            }
        }
        return size;
    }
}

