/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.config;

import com.suncode.plugin.framework.config.URITemplate;
import com.suncode.plugin.framework.requirements.Requirements;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;

public final class PluginDetails {
    private final LocalizedProperty description;
    private final LocalizedProperty author;
    private final Requirements requirements;
    private final URITemplate documentation;
    private final URITemplate changelog;

    public static PluginDetails none() {
        return PluginDetails.builder().requirements(Requirements.licenseRequired(true)).build();
    }

    public String getDescription() {
        return this.description != null ? this.description.getValue() : null;
    }

    public String getAuthor() {
        return this.author != null ? this.author.getValue() : null;
    }

    public Optional<URITemplate> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public Optional<URITemplate> getChangelog() {
        return Optional.ofNullable(this.changelog);
    }

    @ConstructorProperties(value={"description", "author", "requirements", "documentation", "changelog"})
    PluginDetails(LocalizedProperty description, LocalizedProperty author, Requirements requirements, URITemplate documentation, URITemplate changelog) {
        this.description = description;
        this.author = author;
        this.requirements = requirements;
        this.documentation = documentation;
        this.changelog = changelog;
    }

    public static PluginDetailsBuilder builder() {
        return new PluginDetailsBuilder();
    }

    public Requirements getRequirements() {
        return this.requirements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginDetails)) {
            return false;
        }
        PluginDetails other = (PluginDetails)o;
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        Requirements this$requirements = this.getRequirements();
        Requirements other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
            return false;
        }
        Optional<URITemplate> this$documentation = this.getDocumentation();
        Optional<URITemplate> other$documentation = other.getDocumentation();
        if (this$documentation == null ? other$documentation != null : !((Object)this$documentation).equals(other$documentation)) {
            return false;
        }
        Optional<URITemplate> this$changelog = this.getChangelog();
        Optional<URITemplate> other$changelog = other.getChangelog();
        return !(this$changelog == null ? other$changelog != null : !((Object)this$changelog).equals(other$changelog));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        Requirements $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        Optional<URITemplate> $documentation = this.getDocumentation();
        result = result * 59 + ($documentation == null ? 43 : ((Object)$documentation).hashCode());
        Optional<URITemplate> $changelog = this.getChangelog();
        result = result * 59 + ($changelog == null ? 43 : ((Object)$changelog).hashCode());
        return result;
    }

    public String toString() {
        return "PluginDetails(description=" + this.getDescription() + ", author=" + this.getAuthor() + ", requirements=" + this.getRequirements() + ", documentation=" + this.getDocumentation() + ", changelog=" + this.getChangelog() + ")";
    }

    public static class PluginDetailsBuilder {
        private LocalizedProperty description;
        private LocalizedProperty author;
        private Requirements requirements;
        private URITemplate documentation;
        private URITemplate changelog;

        PluginDetailsBuilder() {
        }

        public PluginDetailsBuilder description(LocalizedProperty description) {
            this.description = description;
            return this;
        }

        public PluginDetailsBuilder author(LocalizedProperty author) {
            this.author = author;
            return this;
        }

        public PluginDetailsBuilder requirements(Requirements requirements) {
            this.requirements = requirements;
            return this;
        }

        public PluginDetailsBuilder documentation(URITemplate documentation) {
            this.documentation = documentation;
            return this;
        }

        public PluginDetailsBuilder changelog(URITemplate changelog) {
            this.changelog = changelog;
            return this;
        }

        public PluginDetails build() {
            return new PluginDetails(this.description, this.author, this.requirements, this.documentation, this.changelog);
        }

        public String toString() {
            return "PluginDetails.PluginDetailsBuilder(description=" + this.description + ", author=" + this.author + ", requirements=" + this.requirements + ", documentation=" + this.documentation + ", changelog=" + this.changelog + ")";
        }
    }

    public static class LocalizedProperty {
        private List<PropertyTranslation> translations = new ArrayList<PropertyTranslation>();

        public LocalizedProperty(PropertyTranslation ... translations) {
            Assert.notEmpty((Object[])translations, (String)"At least one property translation is required");
            Collections.addAll(this.translations, translations);
        }

        public String getValue() {
            return this.getValue(LocaleContextHolder.getLocale());
        }

        public String getValue(Locale locale) {
            for (PropertyTranslation translation : this.translations) {
                if (!translation.getLanguage().equals(locale.getLanguage())) continue;
                return translation.getText();
            }
            return this.translations.get(0).getText();
        }
    }

    public static class PropertyTranslation {
        private String text;
        private String language;

        public PropertyTranslation(String text, String language) {
            Assert.hasText((String)language, (String)"Language attribute must not be empty");
            this.text = text;
            this.language = language;
        }

        public String getText() {
            return this.text;
        }

        public String getLanguage() {
            return this.language;
        }
    }
}

