/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.requirements;

import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.requirements.VersionRequirement;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public class MultiVersionRequirement
implements VersionRequirement {
    List<Version> versionRequirements;

    public MultiVersionRequirement(List<Version> versionRequirements) {
        this.versionRequirements = versionRequirements;
        this.validateVersionRequirements();
    }

    private void validateVersionRequirements() {
        Map<String, List<Version>> versionsByMinor = this.versionRequirements.stream().collect(Collectors.groupingBy(v -> v.getMajor() + "." + v.getMinor()));
        versionsByMinor.forEach((minorVersion, versions) -> {
            if (versions.size() > 1) {
                throw new IllegalStateException("More than one version defined for " + minorVersion + ".x");
            }
        });
    }

    @Override
    public Version matchRequiredVersion(Version available) {
        Optional<Version> sameMinorVersion = this.findSameMinorVersion(available);
        if (!sameMinorVersion.isPresent()) {
            sameMinorVersion = this.findHigherVersion(available);
        }
        return sameMinorVersion.orElseGet(() -> this.findLowerVersion(available));
    }

    private Optional<Version> findSameMinorVersion(Version available) {
        List sameMinor = this.versionRequirements.stream().filter(v -> v.getMajor() == available.getMajor() && v.getMinor() == available.getMinor()).collect(Collectors.toList());
        return sameMinor.isEmpty() ? Optional.empty() : Optional.of(sameMinor.get(0));
    }

    private Optional<Version> findHigherVersion(Version available) {
        return this.versionRequirements.stream().filter(version -> version.compareTo(available) > 0).min(Version::compareTo);
    }

    @NonNull
    private Version findLowerVersion(Version available) {
        return this.versionRequirements.stream().filter(version -> version.compareTo(available) < 0).max(Version::compareTo).orElseThrow(NoSuchElementException::new);
    }

    public List<Version> getVersionRequirements() {
        return this.versionRequirements;
    }

    public void setVersionRequirements(List<Version> versionRequirements) {
        this.versionRequirements = versionRequirements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiVersionRequirement)) {
            return false;
        }
        MultiVersionRequirement other = (MultiVersionRequirement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Version> this$versionRequirements = this.getVersionRequirements();
        List<Version> other$versionRequirements = other.getVersionRequirements();
        return !(this$versionRequirements == null ? other$versionRequirements != null : !((Object)this$versionRequirements).equals(other$versionRequirements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiVersionRequirement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Version> $versionRequirements = this.getVersionRequirements();
        result = result * 59 + ($versionRequirements == null ? 43 : ((Object)$versionRequirements).hashCode());
        return result;
    }

    public String toString() {
        return "MultiVersionRequirement(versionRequirements=" + this.getVersionRequirements() + ")";
    }
}

