/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.support;

import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.MenuEntry;
import com.suncode.plugin.framework.web.support.MenuItem;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.plugin.framework.web.support.WebLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;

public class Menu {
    private final String section;
    private final List<MenuItem> items = new ArrayList<MenuItem>();

    public Menu(String section) {
        Assert.hasText((String)section);
        this.section = section;
    }

    public Menu addItem(MenuItem item) {
        Assert.notNull((Object)item);
        this.items.add(item);
        Collections.sort(this.items, OrderComparator.INSTANCE);
        return this;
    }

    public Menu addItems(Collection<MenuItem> items) {
        Assert.notNull(items);
        this.items.addAll(items);
        Collections.sort(this.items, OrderComparator.INSTANCE);
        return this;
    }

    public Menu addEntry(String key, WebLink link, LocalizedMessage label) {
        this.addItem(new MenuEntry(key, link, label, Integer.MAX_VALUE, null));
        return this;
    }

    public String getSection() {
        return this.section;
    }

    public List<MenuItem> getItems() {
        return new ArrayList<MenuItem>(this.items);
    }

    public List<MenuEntry> getSingleEntries() {
        ArrayList<MenuEntry> entries = new ArrayList<MenuEntry>();
        for (MenuItem item : this.items) {
            if (!(item instanceof MenuEntry)) continue;
            entries.add((MenuEntry)item);
        }
        return entries;
    }

    public Menu applyConditions() {
        return this.filter(MenuItem::meetsCondition);
    }

    public Menu applyConditions(Section section) {
        Assert.notNull((Object)section);
        Menu conditionMenu = new Menu(this.getSection());
        for (MenuItem item : this.items) {
            MenuItem view = item.applyConditions(section);
            if (view == null) continue;
            conditionMenu.addItem(view);
        }
        return conditionMenu;
    }

    private Menu filter(Predicate<MenuItem> predicate) {
        Menu menu = new Menu(this.getSection());
        menu.addItems(this.items.stream().filter(predicate).collect(Collectors.toList()));
        return menu;
    }
}

