/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.requirements;

import com.google.common.collect.ImmutableList;
import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.requirements.MultiVersionRequirement;
import com.suncode.plugin.framework.requirements.SingleVersionRequirement;
import com.suncode.plugin.framework.requirements.VersionRequirement;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Requirement {
    @NonNull
    private final String pluginKey;
    private final boolean optional;
    private final List<Version> requiredVersions;
    private final VersionRequirement versionRequirement;

    public Requirement(@NonNull String pluginKey, List<Version> requiredVersions, boolean optional) {
        if (pluginKey == null) {
            throw new NullPointerException("pluginKey");
        }
        this.pluginKey = pluginKey;
        this.requiredVersions = requiredVersions;
        this.optional = optional;
        this.versionRequirement = this.createVersionRequirement(requiredVersions);
    }

    private VersionRequirement createVersionRequirement(List<Version> versions) {
        return versions.size() == 1 ? new SingleVersionRequirement(versions.get(0)) : new MultiVersionRequirement(versions);
    }

    public boolean isMandatory() {
        return !this.optional;
    }

    public boolean isSatisfied(Version available) {
        Version requiredVersion = this.versionRequirement.matchRequiredVersion(available);
        return this.comparable(available).compareTo(this.comparable(requiredVersion)) >= 0;
    }

    private Version comparable(Version version) {
        return version.isSnapshot() ? version.withPatch(Integer.MAX_VALUE) : (version.isReleaseCandidate() ? version.prev() : version);
    }

    public static Requirement optional(String pluginKey, Version requiredVersion) {
        return new Requirement(pluginKey, (List<Version>)ImmutableList.of((Object)requiredVersion), true);
    }

    public static Requirement optional(String pluginKey, List<Version> requiredVersions) {
        return new Requirement(pluginKey, requiredVersions, true);
    }

    public static Requirement mandatory(String pluginKey, Version requiredVersion) {
        return new Requirement(pluginKey, (List<Version>)ImmutableList.of((Object)requiredVersion), false);
    }

    public static Requirement mandatory(String pluginKey, List<Version> requiredVersions) {
        return new Requirement(pluginKey, requiredVersions, false);
    }

    public String toString() {
        String versions = this.requiredVersions.stream().map(Version::toString).collect(Collectors.joining(", "));
        return String.format("%s@%s [optional=%s]", this.pluginKey, versions, this.optional);
    }

    @NonNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public List<Version> getRequiredVersions() {
        return this.requiredVersions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Requirement)) {
            return false;
        }
        Requirement other = (Requirement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pluginKey = this.getPluginKey();
        String other$pluginKey = other.getPluginKey();
        if (this$pluginKey == null ? other$pluginKey != null : !this$pluginKey.equals(other$pluginKey)) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        List<Version> this$requiredVersions = this.getRequiredVersions();
        List<Version> other$requiredVersions = other.getRequiredVersions();
        if (this$requiredVersions == null ? other$requiredVersions != null : !((Object)this$requiredVersions).equals(other$requiredVersions)) {
            return false;
        }
        VersionRequirement this$versionRequirement = this.versionRequirement;
        VersionRequirement other$versionRequirement = other.versionRequirement;
        return !(this$versionRequirement == null ? other$versionRequirement != null : !this$versionRequirement.equals(other$versionRequirement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Requirement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginKey = this.getPluginKey();
        result = result * 59 + ($pluginKey == null ? 43 : $pluginKey.hashCode());
        result = result * 59 + (this.isOptional() ? 79 : 97);
        List<Version> $requiredVersions = this.getRequiredVersions();
        result = result * 59 + ($requiredVersions == null ? 43 : ((Object)$requiredVersions).hashCode());
        VersionRequirement $versionRequirement = this.versionRequirement;
        result = result * 59 + ($versionRequirement == null ? 43 : $versionRequirement.hashCode());
        return result;
    }
}

