/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.support;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.util.XmlUtils;
import com.suncode.plugin.framework.web.support.WebLink;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public class ScopedWebLink
implements WebLink {
    public static final String SCOPED_ATTR = "scoped";
    private boolean scoped;
    private String path;
    private String pluginPath;

    public ScopedWebLink(Plugin plugin, String path) {
        this(plugin, path, true);
    }

    public ScopedWebLink(Plugin plugin, String path, boolean scoped) {
        Assert.notNull((Object)plugin, (String)"Plugin must not be null");
        Assert.notNull((Object)path, (String)"Path must not be null");
        this.scoped = scoped;
        this.path = path.startsWith("/") ? path : "/" + path;
        this.pluginPath = "/plugin/" + plugin.getKey();
    }

    @Override
    public String getPath() {
        if (this.scoped) {
            return this.pluginPath + this.path;
        }
        return this.path;
    }

    public static ScopedWebLink parse(ModuleDefinition module, Plugin plugin) {
        Assert.notNull((Object)module, (String)"Module definition must not be null");
        Element element = XmlUtils.getFirstChildElement("link", module.getElement());
        if (element == null) {
            return null;
        }
        return ScopedWebLink.parse(element, plugin);
    }

    public static ScopedWebLink parse(Element element, Plugin plugin) {
        Assert.notNull((Object)element, (String)"Xml element must not be null");
        Assert.notNull((Object)plugin, (String)"Plugin is not null");
        boolean scoped = true;
        if (element.hasAttribute(SCOPED_ATTR)) {
            scoped = Boolean.valueOf(element.getAttribute(SCOPED_ATTR));
        }
        return new ScopedWebLink(plugin, element.getTextContent().trim(), scoped);
    }
}

