/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.config;

import com.suncode.plugin.framework.requirements.Requirements;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;

public final class PluginDetails {
    private final LocalizedProperty description;
    private final LocalizedProperty author;
    private final Requirements requirements;

    public static PluginDetails none() {
        return PluginDetails.builder().requirements(Requirements.licenseRequired(true)).build();
    }

    public String getDescription() {
        return this.description != null ? this.description.getValue() : null;
    }

    public String getAuthor() {
        return this.author != null ? this.author.getValue() : null;
    }

    @ConstructorProperties(value={"description", "author", "requirements"})
    PluginDetails(LocalizedProperty description, LocalizedProperty author, Requirements requirements) {
        this.description = description;
        this.author = author;
        this.requirements = requirements;
    }

    public static PluginDetailsBuilder builder() {
        return new PluginDetailsBuilder();
    }

    public Requirements getRequirements() {
        return this.requirements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginDetails)) {
            return false;
        }
        PluginDetails other = (PluginDetails)o;
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        Requirements this$requirements = this.getRequirements();
        Requirements other$requirements = other.getRequirements();
        return !(this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        Requirements $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        return result;
    }

    public String toString() {
        return "PluginDetails(description=" + this.getDescription() + ", author=" + this.getAuthor() + ", requirements=" + this.getRequirements() + ")";
    }

    public static class PluginDetailsBuilder {
        private LocalizedProperty description;
        private LocalizedProperty author;
        private Requirements requirements;

        PluginDetailsBuilder() {
        }

        public PluginDetailsBuilder description(LocalizedProperty description) {
            this.description = description;
            return this;
        }

        public PluginDetailsBuilder author(LocalizedProperty author) {
            this.author = author;
            return this;
        }

        public PluginDetailsBuilder requirements(Requirements requirements) {
            this.requirements = requirements;
            return this;
        }

        public PluginDetails build() {
            return new PluginDetails(this.description, this.author, this.requirements);
        }

        public String toString() {
            return "PluginDetails.PluginDetailsBuilder(description=" + this.description + ", author=" + this.author + ", requirements=" + this.requirements + ")";
        }
    }

    public static class PropertyTranslation {
        private String text;
        private String language;

        public PropertyTranslation(String text, String language) {
            Assert.hasText((String)language, (String)"Language attribute must not be empty");
            this.text = text;
            this.language = language;
        }

        public String getText() {
            return this.text;
        }

        public String getLanguage() {
            return this.language;
        }
    }

    public static class LocalizedProperty {
        private List<PropertyTranslation> translations = new ArrayList<PropertyTranslation>();

        public LocalizedProperty(PropertyTranslation ... translations) {
            Assert.notEmpty((Object[])translations, (String)"At least one property translation is required");
            Collections.addAll(this.translations, translations);
        }

        public String getValue() {
            return this.getValue(LocaleContextHolder.getLocale());
        }

        public String getValue(Locale locale) {
            for (PropertyTranslation translation : this.translations) {
                if (!translation.getLanguage().equals(locale.getLanguage())) continue;
                return translation.getText();
            }
            return this.translations.get(0).getText();
        }
    }
}

