/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.Version;
import java.util.function.UnaryOperator;
import lombok.NonNull;

public final class Reference {
    @NonNull
    private final String id;
    @NonNull
    private final Version version;

    public Reference withVersion(Version newVersion) {
        return new Reference(this.id, newVersion);
    }

    public Reference withVersion(UnaryOperator<Version> versionOp) {
        return this.withVersion((Version)versionOp.apply(this.version));
    }

    public static Reference of(Plugin plugin) {
        return Reference.of(plugin.getKey(), Version.parse(plugin.getVersion()));
    }

    public String toString() {
        return this.id + "@" + this.version.toString();
    }

    private Reference(@NonNull String id, @NonNull Version version) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked @NonNull but is null");
        }
        this.id = id;
        this.version = version;
    }

    public static Reference of(@NonNull String id, @NonNull Version version) {
        return new Reference(id, version);
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Version this$version = this.getVersion();
        Version other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Version $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }
}

