/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.requirements;

import com.suncode.plugin.framework.Version;

public interface Resolution {
    public Type getType();

    default public boolean isResolved() {
        return false;
    }

    public <T> T accept(Visitor<T> var1);

    public static interface Visitor<T> {
        public T missing();

        public T versionMismatch(Version var1);

        public T notActive();

        public T running();

        public T licenseUnsatisfied();
    }

    public static final class LicenseUnsatisfied
    implements Resolution {
        private final Type type = Type.LICENSE_UNSATISFIED;

        @Override
        public boolean isResolved() {
            return false;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.licenseUnsatisfied();
        }

        private LicenseUnsatisfied() {
        }

        public static LicenseUnsatisfied licenseUnsatisfied() {
            return new LicenseUnsatisfied();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LicenseUnsatisfied)) {
                return false;
            }
            LicenseUnsatisfied other = (LicenseUnsatisfied)o;
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "Resolution.LicenseUnsatisfied(type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    public static final class Running
    implements Resolution {
        private final Type type = Type.RUNNING;

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.running();
        }

        private Running() {
        }

        public static Running running() {
            return new Running();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Running)) {
                return false;
            }
            Running other = (Running)o;
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "Resolution.Running(type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    public static final class NotActive
    implements Resolution {
        private final Type type = Type.NOT_ACTIVE;

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.notActive();
        }

        private NotActive() {
        }

        public static NotActive notActive() {
            return new NotActive();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotActive)) {
                return false;
            }
            NotActive other = (NotActive)o;
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "Resolution.NotActive(type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    public static final class VersionMismatch
    implements Resolution {
        private final Type type = Type.VERSION_MISMATCH;
        private final Version available;

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.versionMismatch(this.available);
        }

        private VersionMismatch(Version available) {
            this.available = available;
        }

        public static VersionMismatch versionMismatch(Version available) {
            return new VersionMismatch(available);
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public Version getAvailable() {
            return this.available;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VersionMismatch)) {
                return false;
            }
            VersionMismatch other = (VersionMismatch)o;
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Version this$available = this.getAvailable();
            Version other$available = other.getAvailable();
            return !(this$available == null ? other$available != null : !((Object)this$available).equals(other$available));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Version $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            return result;
        }

        public String toString() {
            return "Resolution.VersionMismatch(type=" + (Object)((Object)this.getType()) + ", available=" + this.getAvailable() + ")";
        }
    }

    public static final class Missing
    implements Resolution {
        private final Type type = Type.MISSING;

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.missing();
        }

        private Missing() {
        }

        public static Missing missing() {
            return new Missing();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Missing)) {
                return false;
            }
            Missing other = (Missing)o;
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "Resolution.Missing(type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    public static enum Type {
        MISSING,
        NOT_ACTIVE,
        VERSION_MISMATCH,
        RUNNING,
        LICENSE_UNSATISFIED;

    }
}

