/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.support;

import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.MenuItem;
import com.suncode.plugin.framework.web.support.ResourceLink;
import com.suncode.plugin.framework.web.support.WebLink;
import java.util.List;
import java.util.Optional;
import org.springframework.util.Assert;

public class MenuEntry
extends MenuItem {
    private final String key;
    private final WebLink link;
    private final ResourceLink icon;

    public MenuEntry(String key, WebLink link, LocalizedMessage label, int order, List<Condition> conditions) {
        this(key, link, label, order, conditions, null);
    }

    public MenuEntry(String key, WebLink link, LocalizedMessage label, int order, List<Condition> conditions, ResourceLink icon) {
        super(label, conditions, order);
        Assert.hasText((String)key);
        this.key = key;
        this.link = link;
        this.icon = icon;
    }

    public String getKey() {
        return this.key;
    }

    public WebLink getLink() {
        return this.link;
    }

    public String getLinkPath() {
        return this.link.getPath();
    }

    public Optional<WebLink> getIcon() {
        return Optional.ofNullable(this.icon);
    }
}

