/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.Reference;
import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.requirements.Provided;
import com.suncode.plugin.framework.requirements.Required;
import com.suncode.plugin.framework.requirements.Requirements;
import java.io.File;
import java.util.Collections;
import java.util.Set;

public interface PluginControl {
    public Plugin install(File var1);

    public Operation start(String var1);

    public Operation update(String var1, File var2);

    public Operation stop(String var1);

    public Operation uninstall(String var1);

    public Validation validate(Reference var1, Requirements var2);

    public Validation validate(Plugin var1, Version var2, Requirements var3);

    public static interface Operation {
        public Validation validate();

        public Plugin start();

        public Plugin force();
    }

    public static final class Validation {
        private final Set<Required> required;
        private final Set<Provided> provided;

        public boolean isValid() {
            return this.required.isEmpty() && this.provided.isEmpty();
        }

        public static Validation valid() {
            return new Validation(Collections.emptySet(), Collections.emptySet());
        }

        Validation(Set<Required> required, Set<Provided> provided) {
            this.required = required;
            this.provided = provided;
        }

        public static ValidationBuilder builder() {
            return new ValidationBuilder();
        }

        public Set<Required> getRequired() {
            return this.required;
        }

        public Set<Provided> getProvided() {
            return this.provided;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Validation)) {
                return false;
            }
            Validation other = (Validation)o;
            Set<Required> this$required = this.getRequired();
            Set<Required> other$required = other.getRequired();
            if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
                return false;
            }
            Set<Provided> this$provided = this.getProvided();
            Set<Provided> other$provided = other.getProvided();
            return !(this$provided == null ? other$provided != null : !((Object)this$provided).equals(other$provided));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Required> $required = this.getRequired();
            result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
            Set<Provided> $provided = this.getProvided();
            result = result * 59 + ($provided == null ? 43 : ((Object)$provided).hashCode());
            return result;
        }

        public String toString() {
            return "PluginControl.Validation(required=" + this.getRequired() + ", provided=" + this.getProvided() + ")";
        }

        public static class ValidationBuilder {
            private Set<Required> required;
            private Set<Provided> provided;

            ValidationBuilder() {
            }

            public ValidationBuilder required(Set<Required> required) {
                this.required = required;
                return this;
            }

            public ValidationBuilder provided(Set<Provided> provided) {
                this.provided = provided;
                return this;
            }

            public Validation build() {
                return new Validation(this.required, this.provided);
            }

            public String toString() {
                return "PluginControl.Validation.ValidationBuilder(required=" + this.required + ", provided=" + this.provided + ")";
            }
        }
    }
}

