/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.requirements;

import com.google.common.collect.Sets;
import com.suncode.plugin.framework.requirements.Requirement;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Requirements {
    private final Set<Requirement> requirements;

    public Stream<Requirement> stream() {
        return this.requirements.stream();
    }

    public Set<Requirement> mandatory() {
        return this.select(Requirement::isMandatory);
    }

    public Set<Requirement> optional() {
        return this.select(Requirement::isOptional);
    }

    private Set<Requirement> select(Predicate<Requirement> test) {
        return this.requirements.stream().filter(test).collect(Collectors.toSet());
    }

    public static Requirements of(Requirement ... requirements) {
        return new Requirements(Sets.newHashSet((Object[])requirements));
    }

    public static Requirements of(Collection<Requirement> requirements) {
        return new Requirements(Sets.newHashSet(requirements));
    }

    public static Requirements none() {
        return new Requirements(Collections.emptySet());
    }

    @ConstructorProperties(value={"requirements"})
    Requirements(Set<Requirement> requirements) {
        this.requirements = requirements;
    }

    public static RequirementsBuilder builder() {
        return new RequirementsBuilder();
    }

    public Set<Requirement> getRequirements() {
        return this.requirements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Requirements)) {
            return false;
        }
        Requirements other = (Requirements)o;
        Set<Requirement> this$requirements = this.getRequirements();
        Set<Requirement> other$requirements = other.getRequirements();
        return !(this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Requirement> $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        return result;
    }

    public String toString() {
        return "Requirements(requirements=" + this.getRequirements() + ")";
    }

    public static class RequirementsBuilder {
        private ArrayList<Requirement> requirements;

        RequirementsBuilder() {
        }

        public RequirementsBuilder requirement(Requirement requirement) {
            if (this.requirements == null) {
                this.requirements = new ArrayList();
            }
            this.requirements.add(requirement);
            return this;
        }

        public RequirementsBuilder requirements(Collection<? extends Requirement> requirements) {
            if (this.requirements == null) {
                this.requirements = new ArrayList();
            }
            this.requirements.addAll(requirements);
            return this;
        }

        public RequirementsBuilder clearRequirements() {
            if (this.requirements != null) {
                this.requirements.clear();
            }
            return this;
        }

        public Requirements build() {
            Set<Requirement> requirements;
            switch (this.requirements == null ? 0 : this.requirements.size()) {
                case 0: {
                    requirements = Collections.emptySet();
                    break;
                }
                case 1: {
                    requirements = Collections.singleton(this.requirements.get(0));
                    break;
                }
                default: {
                    requirements = new LinkedHashSet<Requirement>(this.requirements.size() < 0x40000000 ? 1 + this.requirements.size() + (this.requirements.size() - 3) / 3 : Integer.MAX_VALUE);
                    requirements.addAll(this.requirements);
                    requirements = Collections.unmodifiableSet(requirements);
                }
            }
            return new Requirements(requirements);
        }

        public String toString() {
            return "Requirements.RequirementsBuilder(requirements=" + this.requirements + ")";
        }
    }
}

