/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    static Pattern VERSION = Pattern.compile("^(\\d+)(\\.(?<m>\\d+))?(\\.(?<p>\\d+))?([.\\-](?<q>\\w+))?$");
    static Pattern QUALIFIER_VERSION = Pattern.compile("^(\\w+)(\\d+)$");
    static String SNAPSHOT = "SNAPSHOT";
    static String RC = "RC";
    private final int major;
    private final Integer minor;
    private final Integer patch;
    private final String qualifier;
    private final Integer qualifierVersion;

    public int getMinor() {
        return Optional.ofNullable(this.minor).orElse(0);
    }

    public int getPatch() {
        return Optional.ofNullable(this.patch).orElse(0);
    }

    public int getQualifierVersion() {
        return Optional.ofNullable(this.qualifierVersion).orElse(0);
    }

    public boolean hasQualifier() {
        return this.qualifier != null;
    }

    public boolean isSnapshot() {
        return SNAPSHOT.equalsIgnoreCase(this.qualifier);
    }

    public boolean isReleaseCandidate() {
        return RC.equalsIgnoreCase(this.qualifier);
    }

    public Version next() {
        return this.patch != null ? this.withPatch(this.patch + 1) : (this.minor != null ? this.withMinor(this.minor + 1) : this.nextMajor());
    }

    public Version prev() {
        return this.patch != null ? this.withPatch(this.patch - 1) : (this.minor != null ? this.withMinor(this.minor - 1) : this.prevMajor());
    }

    public Version nextMajor() {
        return this.withMajor(this.major + 1);
    }

    public Version prevMajor() {
        return this.withMajor(this.major - 1);
    }

    public static Version parse(org.osgi.framework.Version osgiVersion) {
        return Version.builder().major(osgiVersion.getMajor()).minor(osgiVersion.getMinor()).patch(osgiVersion.getMicro()).qualifier(Strings.emptyToNull((String)osgiVersion.getQualifier())).build();
    }

    public static Version parse(String version) {
        Matcher matcher = VERSION.matcher(version);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Invalid version format");
        return Version.parseQualifierVersion(Version.builder().major(Version.versionNumber(matcher.group(1))).minor(Version.versionNumber(matcher.group("m"))).patch(Version.versionNumber(matcher.group("p"))), matcher);
    }

    private static Version parseQualifierVersion(VersionBuilder version, Matcher matcher) {
        Matcher qualifierVersion;
        String qualifier = matcher.group("q");
        if (qualifier != null && (qualifierVersion = QUALIFIER_VERSION.matcher(qualifier)).matches()) {
            return version.qualifier(qualifierVersion.group(1)).qualifierVersion(Version.versionNumber(qualifierVersion.group(2))).build();
        }
        return version.qualifier(qualifier).build();
    }

    private static Integer versionNumber(String text) {
        return Optional.ofNullable(text).map(Integer::parseInt).orElse(null);
    }

    public static Version random() {
        Random random = new Random();
        return Version.builder().major(random.nextInt(10)).minor(random.nextInt(99)).patch(random.nextInt(99)).build();
    }

    public static Version zero() {
        return Version.builder().build();
    }

    @Override
    public int compareTo(Version other) {
        int result = Integer.compare(this.getMajor(), other.getMajor());
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.getMinor(), other.getMinor());
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.getPatch(), other.getPatch());
        if (result != 0) {
            return result;
        }
        if (this.hasQualifier() && other.hasQualifier()) {
            result = Objects.compare(this.getQualifier(), other.getQualifier(), String::compareToIgnoreCase);
            if (result != 0) {
                return result;
            }
            return Integer.compare(this.getQualifierVersion(), other.getQualifierVersion());
        }
        return Boolean.compare(this.hasQualifier(), other.hasQualifier());
    }

    @JsonValue
    public String toString() {
        return this.major + String.format(".%s.%s", this.getMinor(), this.getPatch()) + (this.qualifier != null ? "." + this.qualifier + (this.qualifierVersion != null ? this.qualifierVersion : "") : "");
    }

    @ConstructorProperties(value={"major", "minor", "patch", "qualifier", "qualifierVersion"})
    Version(int major, Integer minor, Integer patch, String qualifier, Integer qualifierVersion) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
        this.qualifierVersion = qualifierVersion;
    }

    public static VersionBuilder builder() {
        return new VersionBuilder();
    }

    public int getMajor() {
        return this.major;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getPatch() != other.getPatch()) {
            return false;
        }
        String this$qualifier = this.getQualifier();
        String other$qualifier = other.getQualifier();
        if (this$qualifier == null ? other$qualifier != null : !this$qualifier.equals(other$qualifier)) {
            return false;
        }
        return this.getQualifierVersion() == other.getQualifierVersion();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getPatch();
        String $qualifier = this.getQualifier();
        result = result * 59 + ($qualifier == null ? 43 : $qualifier.hashCode());
        result = result * 59 + this.getQualifierVersion();
        return result;
    }

    public Version withMajor(int major) {
        return this.major == major ? this : new Version(major, this.minor, this.patch, this.qualifier, this.qualifierVersion);
    }

    public Version withMinor(Integer minor) {
        return this.minor == minor ? this : new Version(this.major, minor, this.patch, this.qualifier, this.qualifierVersion);
    }

    public Version withPatch(Integer patch) {
        return this.patch == patch ? this : new Version(this.major, this.minor, patch, this.qualifier, this.qualifierVersion);
    }

    public Version withQualifier(String qualifier) {
        return this.qualifier == qualifier ? this : new Version(this.major, this.minor, this.patch, qualifier, this.qualifierVersion);
    }

    public Version withQualifierVersion(Integer qualifierVersion) {
        return this.qualifierVersion == qualifierVersion ? this : new Version(this.major, this.minor, this.patch, this.qualifier, qualifierVersion);
    }

    public static class VersionBuilder {
        private int major;
        private Integer minor;
        private Integer patch;
        private String qualifier;
        private Integer qualifierVersion;

        VersionBuilder() {
        }

        public VersionBuilder major(int major) {
            this.major = major;
            return this;
        }

        public VersionBuilder minor(Integer minor) {
            this.minor = minor;
            return this;
        }

        public VersionBuilder patch(Integer patch) {
            this.patch = patch;
            return this;
        }

        public VersionBuilder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public VersionBuilder qualifierVersion(Integer qualifierVersion) {
            this.qualifierVersion = qualifierVersion;
            return this;
        }

        public Version build() {
            return new Version(this.major, this.minor, this.patch, this.qualifier, this.qualifierVersion);
        }

        public String toString() {
            return "Version.VersionBuilder(major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ", qualifier=" + this.qualifier + ", qualifierVersion=" + this.qualifierVersion + ")";
        }
    }
}

