/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.requirements;

import com.suncode.plugin.framework.Reference;
import com.suncode.plugin.framework.Version;
import java.beans.ConstructorProperties;
import java.util.function.UnaryOperator;
import lombok.NonNull;

public final class Requirement {
    @NonNull
    private final Reference reference;
    private final boolean optional;

    public boolean isMandatory() {
        return !this.optional;
    }

    public boolean isSatisfied(Version available) {
        return available.compareTo(this.getVersion()) >= 0;
    }

    public static Requirement optional(Reference reference) {
        return new Requirement(reference, true);
    }

    public static Requirement mandatory(Reference reference) {
        return new Requirement(reference, false);
    }

    public String toString() {
        return this.reference + " [optional=" + this.optional + "]";
    }

    @ConstructorProperties(value={"reference", "optional"})
    Requirement(@NonNull Reference reference, boolean optional) {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        this.reference = reference;
        this.optional = optional;
    }

    public static RequirementBuilder builder() {
        return new RequirementBuilder();
    }

    @NonNull
    public Reference getReference() {
        return this.reference;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Requirement)) {
            return false;
        }
        Requirement other = (Requirement)o;
        Reference this$reference = this.getReference();
        Reference other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        return this.isOptional() == other.isOptional();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Reference $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : ((Object)$reference).hashCode());
        result = result * 59 + (this.isOptional() ? 79 : 97);
        return result;
    }

    public Reference withVersion(Version newVersion) {
        return this.getReference().withVersion(newVersion);
    }

    public Reference withVersion(UnaryOperator<Version> versionOp) {
        return this.getReference().withVersion(versionOp);
    }

    public String getId() {
        return this.getReference().getId();
    }

    public Version getVersion() {
        return this.getReference().getVersion();
    }

    public static class RequirementBuilder {
        private Reference reference;
        private boolean optional;

        RequirementBuilder() {
        }

        public RequirementBuilder reference(Reference reference) {
            this.reference = reference;
            return this;
        }

        public RequirementBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Requirement build() {
            return new Requirement(this.reference, this.optional);
        }

        public String toString() {
            return "Requirement.RequirementBuilder(reference=" + this.reference + ", optional=" + this.optional + ")";
        }
    }
}

