/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    static Pattern VERSION = Pattern.compile("^(\\d+)(\\.(?<m>\\d+))?(\\.(?<p>\\d+))?([.\\-](?<q>\\w+))?$");
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;

    public Version nextMajor() {
        return this.withMajor(this.major + 1);
    }

    public Version prevMajor() {
        return this.withMajor(this.major - 1);
    }

    public static Version parse(org.osgi.framework.Version osgiVersion) {
        return Version.builder().major(osgiVersion.getMajor()).minor(osgiVersion.getMinor()).patch(osgiVersion.getMicro()).qualifier(Strings.emptyToNull((String)osgiVersion.getQualifier())).build();
    }

    public static Version parse(String version) {
        Matcher matcher = VERSION.matcher(version);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Invalid version format");
        return Version.builder().major(Version.versionNumber(matcher.group(1))).minor(Version.versionNumber(matcher.group("m"))).patch(Version.versionNumber(matcher.group("p"))).qualifier(matcher.group("q")).build();
    }

    private static int versionNumber(String text) {
        return Optional.ofNullable(text).map(Integer::parseInt).orElse(0);
    }

    public static Version random() {
        Random random = new Random();
        return Version.builder().major(random.nextInt(10)).minor(random.nextInt(99)).patch(random.nextInt(99)).build();
    }

    @Override
    public int compareTo(Version other) {
        int result = Integer.compare(this.major, other.major);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.minor, other.minor);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.patch, other.patch);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    @JsonValue
    public String toString() {
        return this.major + String.format(".%s.%s", this.minor, this.patch) + (this.qualifier != null ? "." + this.qualifier : "");
    }

    @ConstructorProperties(value={"major", "minor", "patch", "qualifier"})
    Version(int major, int minor, int patch, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    public static VersionBuilder builder() {
        return new VersionBuilder();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getPatch() != other.getPatch()) {
            return false;
        }
        String this$qualifier = this.getQualifier();
        String other$qualifier = other.getQualifier();
        return !(this$qualifier == null ? other$qualifier != null : !this$qualifier.equals(other$qualifier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getPatch();
        String $qualifier = this.getQualifier();
        result = result * 59 + ($qualifier == null ? 43 : $qualifier.hashCode());
        return result;
    }

    public Version withMajor(int major) {
        return this.major == major ? this : new Version(major, this.minor, this.patch, this.qualifier);
    }

    public static class VersionBuilder {
        private int major;
        private int minor;
        private int patch;
        private String qualifier;

        VersionBuilder() {
        }

        public VersionBuilder major(int major) {
            this.major = major;
            return this;
        }

        public VersionBuilder minor(int minor) {
            this.minor = minor;
            return this;
        }

        public VersionBuilder patch(int patch) {
            this.patch = patch;
            return this;
        }

        public VersionBuilder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Version build() {
            return new Version(this.major, this.minor, this.patch, this.qualifier);
        }

        public String toString() {
            return "Version.VersionBuilder(major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ", qualifier=" + this.qualifier + ")";
        }
    }
}

