/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlUtils {
    public static Element getFirstChildElement(String name, Element parent) {
        NodeList childElements = parent.getElementsByTagName(name);
        return (Element)childElements.item(0);
    }

    public static List<Element> getChildElements(String name, Element parent) {
        NodeList childElements = parent.getElementsByTagName(name);
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < childElements.getLength(); ++i) {
            elements.add((Element)childElements.item(i));
        }
        return elements;
    }

    public static String getFirstChildElementValue(String name, Element parent) {
        Element element = XmlUtils.getFirstChildElement(name, parent);
        if (element != null) {
            return element.getTextContent();
        }
        return null;
    }

    public static Map<String, String> getParameterMap(String name, String keyProperty, Element element) {
        NodeList params = element.getElementsByTagName(name);
        HashMap<String, String> result = new HashMap<String, String>(params.getLength());
        for (int i = 0; i < params.getLength(); ++i) {
            Element param = (Element)params.item(i);
            String key = param.getAttribute(keyProperty);
            String value = param.getTextContent();
            if (!StringUtils.hasText((String)key) || !StringUtils.hasText((String)value)) continue;
            result.put(key, value);
        }
        return result;
    }

    public static Document loadDocument(URL url) throws ParserConfigurationException, IOException, SAXException {
        try (InputStream inputStream = url.openStream();){
            Document document = XmlUtils.loadDocument(inputStream);
            return document;
        }
    }

    public static Document loadDocument(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(inputStream);
        return builder.parse(inputSource);
    }
}

