/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.support;

import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.WebLink;
import java.util.List;
import org.springframework.core.Ordered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuEntry
implements Ordered {
    private final String key;
    private final String section;
    private final int order;
    private final LocalizedMessage label;
    private final WebLink link;
    private final List<Condition> conditions;

    public MenuEntry(String key, String section, WebLink link, LocalizedMessage label, int order, List<Condition> conditions) {
        this.key = key;
        this.link = link;
        this.section = section;
        this.label = label;
        this.order = order;
        this.conditions = conditions;
    }

    public boolean meetsCondition() {
        for (Condition condition : this.conditions) {
            if (condition.isFulfilled()) continue;
            return false;
        }
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public WebLink getLink() {
        return this.link;
    }

    public String getLinkPath() {
        return this.link.getPath();
    }

    public String getSection() {
        return this.section;
    }

    public String getLabel() {
        return this.label.getMessage();
    }

    public LocalizedMessage getLocalizedLabel() {
        return this.label;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public int getOrder() {
        return this.order;
    }
}

