/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.support.module;

import com.suncode.plugin.framework.CompleteKey;
import com.suncode.plugin.framework.Module;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import java.lang.reflect.ParameterizedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleSupport<T>
implements Module<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Plugin plugin;
    private CompleteKey completeKey;
    private ModuleDefinition definition;

    @Override
    public void init(Plugin plugin, ModuleDefinition moduleDefinition) throws PluginsException {
        Assert.notNull((Object)plugin, (String)"Plugin must not be null");
        Assert.notNull((Object)moduleDefinition, (String)"Module definition must not be null");
        this.plugin = plugin;
        this.completeKey = new CompleteKey(plugin.getKey(), moduleDefinition.getKey());
        this.definition = moduleDefinition;
        this.initModule();
    }

    protected abstract void initModule() throws PluginsException;

    @Override
    public void enable() throws PluginsException {
    }

    @Override
    public void disable() throws PluginsException {
    }

    @Override
    public CompleteKey getKey() {
        return this.completeKey;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public ModuleDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public T getObject() {
        return null;
    }

    @Override
    public Class<?> getObjectClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public String toString() {
        return this.definition.getType() + " (" + this.completeKey + ")";
    }
}

