/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.config;

import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.config.PluginDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDescriptor {
    private String key;
    private String name;
    private String hook;
    private PluginDetails details;
    private List<ModuleDefinition> modules = new ArrayList<ModuleDefinition>();

    public PluginDescriptor(String key, String name, String hook, PluginDetails details, List<ModuleDefinition> modules) {
        Assert.hasText((String)key, (String)"Plugin key must not be null");
        Assert.notNull((Object)details, (String)"Plugin details must not be null");
        this.key = key;
        this.hook = hook;
        this.name = name;
        this.details = details;
        this.modules = Collections.unmodifiableList(modules);
    }

    public String getKey() {
        return this.key;
    }

    public String getHook() {
        return this.hook;
    }

    public String getName() {
        return this.name;
    }

    public PluginDetails getDetails() {
        return this.details;
    }

    public List<ModuleDefinition> getModules() {
        return this.modules;
    }

    public String toString() {
        return this.key + " [" + this.name + "]";
    }
}

