/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkConfiguration {
    private File homeDirectory;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public FrameworkConfiguration(File homeDirectory) {
        this(homeDirectory, null);
    }

    public FrameworkConfiguration(File homeDirectory, Map<String, Object> properties) {
        Assert.notNull((Object)homeDirectory, (String)"Home directory must not be null");
        this.homeDirectory = homeDirectory;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public <T> T getProperty(String name) {
        Object value = this.properties.get(name);
        if (value != null) {
            return (T)value;
        }
        return null;
    }

    public void addProperty(String name, Object value) {
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, value);
        }
    }
}

