/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework;

import org.springframework.util.Assert;

public class CompleteKey {
    public static final String SEPARATOR = ":";
    private String pluginKey;
    private String moduleKey;

    public CompleteKey(String completeKey) {
        this(CompleteKey.parse(completeKey));
    }

    public CompleteKey(CompleteKey completeKey) {
        Assert.notNull((Object)completeKey, (String)"Key must not be null");
        this.pluginKey = completeKey.getPluginKey();
        this.moduleKey = completeKey.getModuleKey();
    }

    public CompleteKey(String pluginKey, String moduleKey) {
        Assert.hasText((String)pluginKey, (String)"Plugin key must not be empty");
        Assert.hasText((String)moduleKey, (String)"Module key must not be empty");
        Assert.isTrue((!pluginKey.contains(SEPARATOR) && !moduleKey.contains(SEPARATOR) ? 1 : 0) != 0, (String)"Plugin or module key contains character ':'");
        this.pluginKey = pluginKey;
        this.moduleKey = moduleKey;
    }

    private static CompleteKey parse(String completeKey) {
        Assert.hasText((String)completeKey, (String)"Key must not be empty");
        try {
            String parsedPluginKey = completeKey.substring(0, completeKey.indexOf(SEPARATOR));
            String parsedModuleKey = completeKey.substring(parsedPluginKey.length() + 1);
            return new CompleteKey(parsedPluginKey, parsedModuleKey);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid complete key [" + completeKey + "]", e);
        }
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getCompleteKey() {
        return this.pluginKey + SEPARATOR + this.moduleKey;
    }

    public String toString() {
        return this.getCompleteKey();
    }
}

