/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.support;

import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.MenuEntry;
import com.suncode.plugin.framework.web.support.MenuItem;
import com.suncode.plugin.framework.web.support.Section;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;

public class MenuEntryGroup
extends MenuItem {
    private final Set<MenuEntry> entries = new TreeSet<MenuEntry>((Comparator<MenuEntry>)OrderComparator.INSTANCE);

    public MenuEntryGroup(LocalizedMessage label, int order) {
        this(label, order, null);
    }

    public MenuEntryGroup(LocalizedMessage label, int order, List<Condition> conditions) {
        super(label, conditions, order);
    }

    public MenuEntryGroup addEntry(MenuEntry entry) {
        Assert.notNull((Object)entry);
        this.entries.add(entry);
        return this;
    }

    public MenuEntryGroup addEntries(Collection<MenuEntry> entries) {
        Assert.notNull(entries);
        this.entries.addAll(entries);
        return this;
    }

    public Set<MenuEntry> getMenuEntries() {
        return Collections.unmodifiableSet(this.entries);
    }

    @Override
    public MenuEntryGroup applyConditions(Section section) {
        MenuEntryGroup group = (MenuEntryGroup)super.applyConditions(section);
        if (group != null) {
            ArrayList<MenuEntry> result = new ArrayList<MenuEntry>();
            for (MenuEntry entry : this.entries) {
                if (!entry.meetsCondition(section)) continue;
                result.add(entry);
            }
            if (result.isEmpty()) {
                return null;
            }
            MenuEntryGroup view = new MenuEntryGroup(this.getLabelMessage(), this.getOrder(), this.getConditions());
            view.addEntries(result);
            return view;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }
}

