/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.support;

import com.suncode.plugin.framework.Plugin;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LocalizedMessage {
    private MessageSource messageSource;
    private String code;
    private Object[] arguments;

    public LocalizedMessage(Plugin plugin, String code, Object ... arguments) {
        this((MessageSource)plugin.getContext(), code, arguments);
    }

    public LocalizedMessage(MessageSource messageSource, String code, Object ... arguments) {
        Assert.notNull((Object)messageSource, (String)"MessageSource must not be null");
        this.messageSource = messageSource;
        this.code = code;
        this.arguments = arguments;
    }

    public String getRequiredMessage() {
        return this.messageSource.getMessage(this.code, this.arguments, LocaleContextHolder.getLocale());
    }

    public String getMessage() {
        if (!StringUtils.hasText((String)this.code)) {
            return "";
        }
        try {
            return this.getRequiredMessage();
        }
        catch (NoSuchMessageException e) {
            return this.code;
        }
    }
}

