/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;

public class PluginDetails {
    private LocalizedProperty description;
    private LocalizedProperty author;

    public PluginDetails() {
    }

    public PluginDetails(LocalizedProperty description, LocalizedProperty author) {
        this.description = description;
        this.author = author;
    }

    public String getDescription() {
        return this.description != null ? this.description.getValue() : null;
    }

    public String getAuthor() {
        return this.author != null ? this.author.getValue() : null;
    }

    public static class PropertyTranslation {
        private String text;
        private String language;

        public PropertyTranslation(String text, String language) {
            Assert.hasText((String)language, (String)"Language attribute must not be empty");
            this.text = text;
            this.language = language;
        }

        public String getText() {
            return this.text;
        }

        public String getLanguage() {
            return this.language;
        }
    }

    public static class LocalizedProperty {
        private List<PropertyTranslation> translations = new ArrayList<PropertyTranslation>();

        public LocalizedProperty(PropertyTranslation ... translations) {
            Assert.notEmpty((Object[])translations, (String)"At least one property transaltion is required");
            Collections.addAll(this.translations, translations);
        }

        public String getValue() {
            return this.getValue(LocaleContextHolder.getLocale());
        }

        public String getValue(Locale locale) {
            for (PropertyTranslation translation : this.translations) {
                if (!translation.getLanguage().equals(locale.getLanguage())) continue;
                return translation.getText();
            }
            return this.translations.get(0).getText();
        }
    }
}

