/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail.receivers;

import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.SendMailSender;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.FinderFactory;
import jakarta.mail.MessagingException;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class OrganizationalUnitNameReceiver
implements Receiver {
    private String organizationalUnitName;

    @Override
    public ReceiverTypes getType() {
        return ReceiverTypes.OU_BY_NAME;
    }

    @Override
    public void send(String receiverId, String subject, String content, List<WfDocument> attachments, List<String> excludedEmails, String processId) throws MessagingException {
        this.organizationalUnitName = receiverId;
        OrganizationalUnitFinder ouFinder = FinderFactory.getOrganizationalUnitFinder();
        PositionFinder positionFinder = FinderFactory.getPositionFinder();
        for (OrganizationalUnit ou : ouFinder.findByName(this.organizationalUnitName, new String[0])) {
            for (Position position : positionFinder.getAll(new String[]{"organizationalUnit", "user"})) {
                User user;
                if (!position.getOrganizationalUnit().equals((Object)ou) || excludedEmails.contains((user = position.getUser()).getEmail())) continue;
                SendMailSender.getInstance().send(user.getEmail(), subject, content, attachments);
                excludedEmails.add(user.getEmail());
            }
        }
    }
}

