/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.CUF.util.extension.historyTree.TaskTree;
import com.plusmpm.CUF.util.extension.historyTree.TreeData;
import com.plusmpm.database.DBManagement;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GetTreeData
extends HttpServlet {
    private static Logger log = Logger.getLogger(GetTreeData.class);

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map map = req.getParameterMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            params.put(key, ((Object[])map.get(key))[0]);
        }
        String className = req.getParameter("className");
        try {
            Class<?> clazz = Class.forName(className);
            TaskTree td = (TaskTree)clazz.newInstance();
            List<TreeData> treeData = td.getData(params);
            Map<String, TreeData> dataMap = this.convert(treeData);
            List<Map<String, Object>> result = this.read(treeData, dataMap);
            ObjectMapper om = new ObjectMapper();
            SimpleDateFormat df = new SimpleDateFormat(DBManagement.CONST_DATEFORMAT);
            om.setDateFormat((DateFormat)df);
            String json = om.writeValueAsString(result);
            log.info((Object)json);
            resp.setContentType("application/json");
            resp.getWriter().print(json);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private List<Map<String, Object>> read(List<TreeData> treeData, Map<String, TreeData> dataMap) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (TreeData treeData2 : treeData) {
            treeData2.getData().put("leaf", true);
            if (StringUtils.isNotBlank((String)treeData2.getParentId())) {
                List<Map<String, Object>> childs;
                TreeData parent = dataMap.get(treeData2.getParentId());
                Map<String, Object> parentData = parent.getData();
                if (parentData.containsKey("children")) {
                    childs = (List)parentData.get("children");
                    childs.add(treeData2.getData());
                    continue;
                }
                childs = new ArrayList();
                childs.add(treeData2.getData());
                parentData.put("children", childs);
                continue;
            }
            result.add(treeData2.getData());
        }
        for (Map map : result) {
            if (!map.containsKey("children")) continue;
            map.put("leaf", false);
        }
        return result;
    }

    private Map<String, TreeData> convert(List<TreeData> treeData) {
        HashMap<String, TreeData> map = new HashMap<String, TreeData>();
        for (TreeData td : treeData) {
            map.put(td.getId(), td);
        }
        return map;
    }
}

