/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail.receivers;

import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.SendMailSender;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.ServiceFactory;
import jakarta.mail.MessagingException;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class GroupReceiver
implements Receiver {
    private String groupName;

    @Override
    public ReceiverTypes getType() {
        return ReceiverTypes.GROUP;
    }

    @Override
    public void send(String receiverId, String subject, String content, List<WfDocument> attachments, List<String> excludedEmails, String processId) throws MessagingException {
        this.groupName = receiverId;
        UserService userService = ServiceFactory.getUserService();
        for (User user : userService.getGroup(this.groupName, new String[]{"users"}).getUsers()) {
            if (excludedEmails.contains(user.getEmail())) continue;
            SendMailSender.getInstance().send(user.getEmail(), subject, content, attachments);
            excludedEmails.add(user.getEmail());
        }
    }
}

