/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.administration.email.EmailMessage;
import com.suncode.pwfl.administration.email.EmailService;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DiskSpaceNotification
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(DiskSpaceNotification.class);

    @AdvancedTask(name="DiskSpaceNotification", description="DiskSpaceNotification_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void FreeDiskSpaceNotification(@TaskParam(name="advancedTask.paramName.diskPath", description="advancedTask.paramDesc.diskPath") String sDiskPath, @TaskParam(name="advancedTask.paramName.tresholdInMB", description="advancedTask.paramDesc.tresholdInMB") String sTresholdInMB, @TaskParam(name="advancedTask.paramName.emails", description="advancedTask.paramDesc.emails") String sEmails, @TaskParam(name="advancedTask.paramName.templatePath", description="advancedTask.paramDesc.templatePath") String sTemplatePath, @TaskParam(name="advancedTask.paramName.subject", description="advancedTask.paramDesc.subject") String sSubject) {
        log.trace((Object)("************ FreeDiskSpaceNotification(sDiskPath=" + sDiskPath + ", sTresholdInMB=" + sTresholdInMB + ", sEmails=, sTemplatePath=" + sTemplatePath + ", sSubject=" + sSubject + ") ************"));
        long startTime = new Date().getTime();
        long lTresholdInMB = new Long(-1L);
        long lTresholdInBytes = new Long(-1L);
        long lFreeSpaceInBytes = new Long(-1L);
        File fDiskPath = null;
        HashMap<String, Object> putInTemplateMap = null;
        try {
            try {
                lTresholdInMB = Long.parseLong(sTresholdInMB);
                if (lTresholdInMB <= 0L) {
                    throw new CUFException("Limit wolnego miejsca w MB nie jest wartoscia dodatnia");
                }
            }
            catch (NumberFormatException e) {
                taskLog.error((Object)e.getMessage());
                throw new CUFException("Limit wolnego miejsca w MB nie jest wartoscia liczbowa");
            }
            log.info((Object)("Weryfikacja lokalizacji " + sDiskPath + " na dysku lokalnym"));
            fDiskPath = new File(sDiskPath);
            if (!fDiskPath.exists()) {
                throw new CUFException("Lokalizacja " + sDiskPath + " nie istnieje na dysku lokalnym");
            }
            log.info((Object)("Lokalizacja " + sDiskPath + " istnieje na dysku lokalnym"));
            lFreeSpaceInBytes = fDiskPath.getFreeSpace();
            lTresholdInBytes = lTresholdInMB * 1024L * 1024L;
            if (lFreeSpaceInBytes < lTresholdInBytes) {
                log.info((Object)("W lokalizacji " + sDiskPath + " ilosc wolnego miejsca jest mniejsza niz " + lTresholdInMB + " MB. Wysylanie powiadomienia"));
                putInTemplateMap = new HashMap<String, Object>();
                putInTemplateMap.put("@DISK_PATH@", sDiskPath);
                putInTemplateMap.put("@DISK_FREE_SPACE@", String.valueOf(Math.round(new Double(lFreeSpaceInBytes / 0x100000L))) + " MB");
                putInTemplateMap.put("@DISK_FREE_SPACE_LIMIT@", String.valueOf(lTresholdInMB) + " MB");
                EmailService emailService = (EmailService)SpringContext.getBean(EmailService.class);
                EmailMessage emailMessage = EmailMessage.builder().recipients(Arrays.asList(sEmails.split(","))).subject(sSubject).template(new File(sTemplatePath)).params(putInTemplateMap).isHtml(true).build();
                emailService.send(emailMessage);
            } else {
                log.info((Object)("W lokalizacji " + sDiskPath + " ilosc wolnego miejsca jest wieksza niz " + lTresholdInMB + " MB"));
            }
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego FreeDiskSpaceNotification: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

