/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocumentTemplateTable;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.plusmpm.util.workflowData.ProcessData;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

@Deprecated(since="4.2", forRemoval=true)
public class ExportDocumentTemplates
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportDocumentTemplates.class);

    @AdvancedTask(name="ExportDocumentTemplatesToXLS", description="ExportDocumentTemplatesToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportDocumentTemplatesToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportDocumentTemplatesToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        DBManagement dbm = new DBManagement();
        Map processDefIdsAndNamesMap = null;
        ArrayList documentTemplatesList = null;
        String processName = "";
        int columnPos = 0;
        int rowPos = 0;
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet documentTemplatesSheet = workbook.createSheet("Szablony dokument\u00f3w", 0);
            String[] colIDsDocTemplate = new String[]{"Nazwa procesu", "Nazwa szablonu", "\u015acie\u017cka"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (int i = 0; i < colIDsDocTemplate.length; ++i) {
                CUFTools.addCellToXLSSheet(documentTemplatesSheet, columnPos, 0, colIDsDocTemplate[i], times12format, cellView);
                ++columnPos;
            }
            log.info((Object)"Pobieranie szablonow dokumentow z systemu");
            ProcessData processData = new ProcessData();
            processDefIdsAndNamesMap = processData.getProcessDefIdsNames();
            if (processDefIdsAndNamesMap != null && processDefIdsAndNamesMap.size() > 0) {
                for (String sProcDefId : processDefIdsAndNamesMap.keySet()) {
                    if (Tools.isNullOrEmpty((String)sProcDefId)) continue;
                    log.info((Object)("Pobieranie szablonow dokumentow dla procesu o identyfikatorze definicji " + sProcDefId));
                    documentTemplatesList = dbm.GetAllDocumentTemplates(sProcDefId);
                    if (documentTemplatesList != null && documentTemplatesList.size() > 0) {
                        processName = CUFTools.getProcessNameForProcDefId(sProcDefId);
                        for (DocumentTemplateTable oneDocumentTemplate : documentTemplatesList) {
                            if (oneDocumentTemplate == null) continue;
                            columnPos = 0;
                            String docTemplateName = oneDocumentTemplate.getTemplateName();
                            String docTemplatepath = oneDocumentTemplate.getTemplatePath();
                            log.info((Object)("Eksport danych o szablonie dokumentu o nazwie " + docTemplateName));
                            CUFTools.addCellToXLSSheet(documentTemplatesSheet, columnPos, ++rowPos, processName, null, cellView);
                            CUFTools.addCellToXLSSheet(documentTemplatesSheet, ++columnPos, rowPos, docTemplateName, null, cellView);
                            CUFTools.addCellToXLSSheet(documentTemplatesSheet, ++columnPos, rowPos, docTemplatepath, null, cellView);
                            ++columnPos;
                        }
                        continue;
                    }
                    log.info((Object)("Brak szablonow dokumentow dla procesu o identyfikatorze definicji " + sProcDefId));
                }
            } else {
                log.warn((Object)"Brak procesow w systemie");
            }
            log.info((Object)"Utworzono arkusz do eksportu szablonow dokumentow");
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport szablonow dokumentow do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania szablonow dokumentow. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportDocumentTemplatesToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

