/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocumentTemplateTable;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;

@Deprecated(since="4.2", forRemoval=true)
public class ImportDocumentTemplates
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportDocumentTemplates.class);

    @AdvancedTask(name="ImportDocumentTemplatesFromXLS", description="ImportDocumentTemplatesFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportDocumentTemplatesFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportDocumentTemplatesFromXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        DBManagement dbm = new DBManagement();
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Szablony dokument\u00f3w");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Szablony dokument\u00f3w w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 3; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z szablonami dokumentow");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String processName = sheet.getCell(((Integer)header.get("Nazwa procesu")).intValue(), i).getContents();
                    String procDefId = "";
                    String docTemplateName = sheet.getCell(((Integer)header.get("Nazwa szablonu")).intValue(), i).getContents();
                    String docTemplatePath = sheet.getCell(((Integer)header.get("\u015acie\u017cka")).intValue(), i).getContents();
                    if (Tools.isNullOrEmpty((String)processName)) continue;
                    if (Tools.isNullOrEmpty((String)docTemplateName)) {
                        throw new CUFException("Brak nazwy szablonu dokumentu");
                    }
                    if (Tools.isNullOrEmpty((String)docTemplatePath)) {
                        throw new CUFException("Brak sciezki do szablonu dokumentu o nazwie " + docTemplateName);
                    }
                    procDefId = CUFTools.getProcDefIdForProcessName(processName);
                    if (Tools.isNullOrEmpty((String)procDefId)) {
                        throw new CUFException("W systemie nie istnieje proces o nazwie " + processName);
                    }
                    if (ArchiveServices.DoesTemplateExistForProcess(procDefId, docTemplateName)) {
                        throw new CUFException("Szablon dokumentu o nazwie " + docTemplateName + " istnieje juz dla procesu o nazwie " + processName);
                    }
                    DocumentTemplateTable documentTemplateTable = new DocumentTemplateTable(docTemplateName, docTemplatePath, procDefId);
                    long id = dbm.addDocumentTemplate(documentTemplateTable);
                    if (id == -1L) {
                        throw new CUFException("Blad podczas dodawania do systemu szablonu dokumentu o nazwie " + docTemplateName + " dla procesu o nazwie " + processName);
                    }
                    log.info((Object)("Poprawnie dodano do systemu szablon dokumentu o nazwie " + docTemplateName + " dla procesu o nazwie " + processName));
                    continue;
                }
                catch (CUFException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import szablonow dokumentow");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportDocumentTemplatesFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

