/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office.model.reader;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.reader.ResolvableValueReader;
import com.suncode.cuf.io.office.model.reader.ValueReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ValueReaderResolver {
    private static ValueReaderResolver instance;
    private List<ResolvableValueReader> readers = new ArrayList<ResolvableValueReader>();

    private ValueReaderResolver() {
        Reflections reflections = new Reflections(ValueReaderResolver.class.getPackage().getName(), new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(ResolvableValueReader.class);
        for (Class type : subTypes) {
            try {
                this.readers.add((ResolvableValueReader)type.newInstance());
            }
            catch (Exception e) {
                throw new CUFServiceException("Can't create class: " + String.valueOf(type), e);
            }
        }
        Collections.sort(this.readers, new Comparator<ResolvableValueReader>(){

            @Override
            public int compare(ResolvableValueReader r1, ResolvableValueReader r2) {
                return r2.getPriority() - r1.getPriority();
            }
        });
    }

    public static ValueReaderResolver getInstance() {
        if (instance == null) {
            instance = new ValueReaderResolver();
        }
        return instance;
    }

    public ValueReader resolve(int cellType, Cell cell) {
        for (ResolvableValueReader reader : this.readers) {
            if (!reader.canResolveValue(cellType, cell)) continue;
            return reader;
        }
        throw new CUFServiceException("Not supportet cell type: " + cellType + " cell: " + String.valueOf(cell));
    }
}

