/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.web.controller;

import com.suncode.cuf.search.hibernate.HibernateFinder;
import com.suncode.cuf.search.hibernate.HibernateQueryDefinition;
import com.suncode.cuf.security.RightChecker;
import com.suncode.cuf.security.level.DocumentClassRightLevel;
import com.suncode.cuf.web.controller.AbstractDocumentClassController;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.search.CountedResult;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"cuf/documentclass/protected"})
public class ProtectedDocumentClassController
extends AbstractDocumentClassController {
    @Autowired
    private RightChecker rightChecker;

    @Override
    protected HibernateFinder getProxy() {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                List list = null;
                if (method.equals(HibernateFinder.class.getMethod("find", HibernateQueryDefinition.class))) {
                    list = (List)method.invoke((Object)ProtectedDocumentClassController.this.finder, args);
                    this.filterUserRights(list);
                    return list;
                }
                if (method.equals(HibernateFinder.class.getMethod("findCounted", HibernateQueryDefinition.class))) {
                    CountedResult data = (CountedResult)method.invoke((Object)ProtectedDocumentClassController.this.finder, args);
                    list = data.getData();
                    this.filterUserRights(list);
                    return data;
                }
                return method.invoke((Object)ProtectedDocumentClassController.this.finder, args);
            }

            private void filterUserRights(List<DocumentClass> list) {
                ArrayList<DocumentClass> ret = new ArrayList<DocumentClass>();
                for (DocumentClass dc : list) {
                    if (ProtectedDocumentClassController.this.rightChecker.hasRightToDocumentClass(dc.getId(), DocumentClassRightLevel.ADD_DOCUMENTS)) continue;
                    ret.add(dc);
                }
                list.removeAll(ret);
            }
        };
        HibernateFinder t = (HibernateFinder)Proxy.newProxyInstance(HibernateFinder.class.getClassLoader(), new Class[]{HibernateFinder.class}, handler);
        return t;
    }
}

