/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.Tools;
import com.plusmpm.util.UsersManagement;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.util.FinderFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.jooq.tools.StringUtils;

@Deprecated(since="4.2", forRemoval=true)
public class ExportUsers
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportUsers.class);
    private volatile double progress = 0.0;

    public Double getProgress() {
        return this.progress;
    }

    @AdvancedTask(name="ExportUsersToXLS", description="ExportUsersToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportUsersToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) throws IOException, RowsExceededException, WriteException {
        log.info((Object)("********************* ExportUsersToXLS(sXLSPath=" + sXLSPath + ") ***************"));
        long startTime = new Date().getTime();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        DBManagement dbm = new DBManagement();
        UsersManagement um = new UsersManagement();
        File xls = null;
        WorkbookSettings wbs = null;
        WritableWorkbook w = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        PositionFinder ps = FinderFactory.getPositionFinder();
        OrganizationalUnitFinder ous = FinderFactory.getOrganizationalUnitFinder();
        int colPos = 0;
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            w = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet usersSheet = w.createSheet("U\u017cytkownicy", 0);
            log.info((Object)"Arkusz do eksportu struktury organizacyjnej stworzony");
            String[] colIDs = new String[]{"Imi\u0119", "Nazwisko", "Login", "Has\u0142o", "Email", "Nr", "Grupy", "Nazwa stanowiska", "Symbol stanowiska", "Symbol stanowiska nadrz\u0119dnego", "Rola", "Nazwa jednostki organizacyjnej", "Symbol jednostki organizacyjnej", "Symbol jednostki nadrz\u0119dnej", "Symbol stanowiska kierowniczego"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (int i = 0; i < colIDs.length; ++i) {
                CUFTools.addCellToXLSSheet(usersSheet, colPos, 0, colIDs[i], times12format, cellView);
                ++colPos;
            }
            String[] users = uga.getAllUsers();
            int rowPos = 1;
            String adminId = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            int usersCount = users.length;
            int i = 0;
            for (String user : users) {
                this.progress = (double)(++i) / (double)usersCount;
                if (user == null || user.equalsIgnoreCase(adminId)) continue;
                log.info((Object)("Uzupelnianie danych dla uzytkownika " + user));
                String userName = uga.getUserFirstName(user);
                String userSurname = uga.getUserLastName(user);
                String userEmail = uga.getUserEMailAddress(user);
                String userNumber = "";
                Object userGroups = "";
                Object userPositionNames = "";
                Object userPositionSymbols = "";
                Object userHigherPositionSymbols = "";
                Object roles = "";
                Object OUNames = "";
                Object OUSymbols = "";
                Object OUDirIDs = "";
                Object HigherOUs = "";
                log.info((Object)("Pobieranie grup dla uzytkownika " + user));
                List<String> groupsOfUser = CUFTools.getGroupForUser(user);
                if (groupsOfUser != null) {
                    for (int j = 0; j < groupsOfUser.size(); ++j) {
                        userGroups = j != groupsOfUser.size() - 1 ? (String)userGroups + groupsOfUser.get(j) + ";" : (String)userGroups + groupsOfUser.get(j);
                    }
                    log.info((Object)("Grupy uzytkownika " + user + " to: " + (String)userGroups));
                }
                PositionFinder pf = FinderFactory.getPositionFinder();
                List userPositionTables = pf.findByUserName(user, new String[]{"higherPosition", "organizationalUnit"});
                for (Position positionsTable : userPositionTables) {
                    String thisHigherOUSymbol;
                    OrganizationalUnit higherOUTable;
                    Long thisHigherOUId;
                    String thisDirPosSymbol;
                    Position dirPositionsTable;
                    Long thisDirId;
                    OrganizationalUnit ouTable;
                    Long thisOUId;
                    String thisHigherPosSymbol;
                    Position higherPositionsTable;
                    Long thisHigherPosId;
                    String thisPosName = positionsTable.getName();
                    String thisPosSymbol = positionsTable.getSymbol();
                    if (!Tools.isNullOrEmpty((String)thisPosSymbol)) {
                        userPositionSymbols = (String)userPositionSymbols + thisPosSymbol + ";";
                        userPositionNames = !Tools.isNullOrEmpty((String)thisPosName) ? (String)userPositionNames + thisPosName + ";" : (String)userPositionNames + thisPosSymbol + ";";
                    }
                    if ((thisHigherPosId = positionsTable.getHigherPosition().getId()) != null && (higherPositionsTable = positionsTable.getHigherPosition()) != null && !Tools.isNullOrEmpty((String)(thisHigherPosSymbol = higherPositionsTable.getSymbol()))) {
                        userHigherPositionSymbols = (String)userHigherPositionSymbols + thisHigherPosSymbol + ";";
                    }
                    if ((thisOUId = positionsTable.getOrganizationalUnit().getId()) == null || (ouTable = positionsTable.getOrganizationalUnit()) == null) continue;
                    String thisOUSymbol = ouTable.getSymbol();
                    String thisOUName = ouTable.getName();
                    if (!Tools.isNullOrEmpty((String)thisOUSymbol)) {
                        OUSymbols = (String)OUSymbols + thisOUSymbol + ";";
                        OUNames = !Tools.isNullOrEmpty((String)thisOUName) ? (String)OUNames + thisOUName + ";" : (String)OUNames + thisOUSymbol + ";";
                    }
                    if ((thisDirId = ouTable.getDirectorPosition().getId()) != null && (dirPositionsTable = (Position)ps.get((Serializable)thisDirId)) != null && !Tools.isNullOrEmpty((String)(thisDirPosSymbol = dirPositionsTable.getSymbol()))) {
                        OUDirIDs = (String)OUDirIDs + thisDirPosSymbol + ";";
                    }
                    if ((thisHigherOUId = ouTable.getHigherOrganizationalUnit().getId()) == null || (higherOUTable = (OrganizationalUnit)ous.get((Serializable)thisHigherOUId)) == null || Tools.isNullOrEmpty((String)(thisHigherOUSymbol = higherOUTable.getSymbol()))) continue;
                    HigherOUs = (String)HigherOUs + thisHigherOUSymbol + ";";
                }
                List userRolesList = FinderFactory.getRoleFinder().findByUserName(user);
                if (userRolesList != null && userRolesList.size() > 0) {
                    for (Role oneRole : userRolesList) {
                        roles = (String)roles + this.buildRoleId(oneRole) + ";";
                    }
                }
                if (((String)userPositionNames).endsWith(";")) {
                    userPositionNames = ((String)userPositionNames).substring(0, ((String)userPositionNames).length() - 1);
                }
                if (((String)userPositionSymbols).endsWith(";")) {
                    userPositionSymbols = ((String)userPositionSymbols).substring(0, ((String)userPositionSymbols).length() - 1);
                }
                if (((String)userHigherPositionSymbols).endsWith(";")) {
                    userHigherPositionSymbols = ((String)userHigherPositionSymbols).substring(0, ((String)userHigherPositionSymbols).length() - 1);
                }
                if (((String)roles).endsWith(";")) {
                    roles = ((String)roles).substring(0, ((String)roles).length() - 1);
                }
                if (((String)OUNames).endsWith(";")) {
                    OUNames = ((String)OUNames).substring(0, ((String)OUNames).length() - 1);
                }
                if (((String)OUSymbols).endsWith(";")) {
                    OUSymbols = ((String)OUSymbols).substring(0, ((String)OUSymbols).length() - 1);
                }
                if (((String)OUDirIDs).endsWith(";")) {
                    OUDirIDs = ((String)OUDirIDs).substring(0, ((String)OUDirIDs).length() - 1);
                }
                if (((String)HigherOUs).endsWith(";")) {
                    HigherOUs = ((String)HigherOUs).substring(0, ((String)HigherOUs).length() - 1);
                }
                log.info((Object)("Eksport pozostalych danych dla uzytkownika " + user));
                colPos = 0;
                CUFTools.addCellToXLSSheet(usersSheet, colPos, rowPos, userName, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, userSurname, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, user, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, "", null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, userEmail, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, userNumber, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, (String)userGroups, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, (String)userPositionNames, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, (String)userPositionSymbols, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, (String)userHigherPositionSymbols, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, (String)roles, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, (String)OUNames, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, (String)OUSymbols, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, (String)HigherOUs, null, cellView);
                CUFTools.addCellToXLSSheet(usersSheet, ++colPos, rowPos, (String)OUDirIDs, null, cellView);
                ++colPos;
                ++rowPos;
                taskLog.info((Object)("Uzytkownik " + user + " wraz z komponentami wyeksportowany do " + sXLSPath));
                log.info((Object)("Uzytkownik " + user + " wraz z komponentami wyeksportowany do " + sXLSPath));
            }
            w.write();
            w.close();
            taskLog.info((Object)("Eksport calej struktury organizacyjnej do " + sXLSPath + " zakonczony sukcesem"));
            log.info((Object)("Eksport calej struktury organizacyjnej do " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania widokow domyslnych dla uzytkownikow. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    w.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        this.progress = 1.0;
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportUsersToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private String buildRoleId(Role role) {
        return StringUtils.join((Object[])new String[]{role.getPackageId(), ":", role.getProcessDefId(), ":", role.getRoleId()});
    }
}

