/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.util.Date;
import java.util.List;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

@Deprecated(since="4.2", forRemoval=true)
public class ExportDevices
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportDevices.class);

    @AdvancedTask(name="ExportDevicesToXLS", description="ExportDevicesToXLS", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportDevicesToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportDevicesToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        DBManagement dbm = new DBManagement();
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        List devices = null;
        int colPos = 0;
        int rowPos = 0;
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet devicesSheet = workbook.createSheet("Urz\u0105dzenia", 0);
            log.info((Object)"Utworzono arkusz do eksportu urzadzen");
            String[] colIDs = new String[]{"Nazwa urz\u0105dzenia", "\u015acie\u017cka", "Rozmiar [MB]"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (int i = 0; i < colIDs.length; ++i) {
                CUFTools.addCellToXLSSheet(devicesSheet, colPos, 0, colIDs[i], times12format, cellView);
                ++colPos;
            }
            log.info((Object)"Utworzono naglowki w arkuszu");
            log.info((Object)"Pobieranie urzadzen z systemu");
            devices = as.getAllDevices(new String[0]);
            if (devices != null && devices.size() > 0) {
                for (Device oneDevice : devices) {
                    if (oneDevice == null) continue;
                    colPos = 0;
                    ++rowPos;
                    String deviceName = oneDevice.getDeviceName();
                    String devicePath = "Podaj \u015bcie\u017ck\u0119";
                    Long lDeviceSize = oneDevice.getDeviceSize();
                    String deviceSize = "";
                    log.info((Object)("Eksportowanie danych o urzadzeniu " + deviceName));
                    if (lDeviceSize != null && lDeviceSize > 0L) {
                        deviceSize = String.valueOf(lDeviceSize);
                    }
                    CUFTools.addCellToXLSSheet(devicesSheet, colPos, rowPos, deviceName, null, cellView);
                    CUFTools.addCellToXLSSheet(devicesSheet, ++colPos, rowPos, devicePath, null, cellView);
                    CUFTools.addCellToXLSSheet(devicesSheet, ++colPos, rowPos, deviceSize, null, cellView);
                    ++colPos;
                }
            } else {
                log.info((Object)"Brak urzadzen zdefiniowanych w systemie");
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport urzadzen do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania urzadzen. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportDevicesToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

