/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.template;

import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.activity.DelegatedActivity;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class WordTemplateActivityHistoryWrapper {
    private final List<Activity> activitiesFromProcess;
    private ActivityService activityService;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public WordTemplateActivityHistoryWrapper(List<Activity> activitiesFromProcess) {
        this.activitiesFromProcess = activitiesFromProcess.stream().sorted(Comparator.comparing(Activity::getCreatedTime)).collect(Collectors.toList());
        this.activityService = ServiceFactory.getActivityService();
    }

    public String getHistoryActivitiesNames() {
        return this.activitiesFromProcess.stream().map(Activity::getName).collect(Collectors.joining(";"));
    }

    public String getHistoryActivitiesStartDates() {
        return this.activitiesFromProcess.stream().map(activity -> dateFormat.format(activity.getCreatedTime())).collect(Collectors.joining(";"));
    }

    public String getHistoryActivitiesFinishDates() {
        return this.activitiesFromProcess.stream().map(activity -> dateFormat.format(activity.getLastStateTime())).collect(Collectors.joining(";"));
    }

    public String getHistoryActivitiesPerformers() {
        return this.activitiesFromProcess.stream().map(activity -> this.getUsersDelegations((Activity)activity)).collect(Collectors.joining(";"));
    }

    private String getUsersDelegations(Activity activity) {
        String resourceIds = activity.getResourceId();
        List<String> activityUsers = new ArrayList<String>();
        if (activity.isOpen()) {
            activityUsers = this.activityService.getAssignments(activity.getProcessId(), activity.getActivityId());
        }
        if (activityUsers.isEmpty() && StringUtils.isNotBlank((String)resourceIds)) {
            activityUsers.add(resourceIds);
        }
        Object delegationsWrap = "";
        for (String user : activityUsers) {
            delegationsWrap = (String)delegationsWrap + WordTemplateActivityHistoryWrapper.getRealUserName(user);
            List delegations = this.activityService.getActivityDelegations(activity.getActivityId(), user);
            if (delegations != null) {
                delegationsWrap = (String)delegationsWrap + WordTemplateActivityHistoryWrapper.getDelegationInfo(delegations);
            }
            delegationsWrap = (String)delegationsWrap + ", ";
        }
        if (!StringUtils.isBlank((String)delegationsWrap)) {
            return ((String)delegationsWrap).substring(0, ((String)delegationsWrap).lastIndexOf(","));
        }
        return delegationsWrap;
    }

    public String getHistoryActivitiesStatuses() {
        return this.activitiesFromProcess.stream().map(Activity::getState).map(ActivityState::getSharkState).map(stateName -> MessageHelper.getMessage((String)("task." + stateName))).collect(Collectors.joining(";"));
    }

    private static String getDelegationInfo(List<DelegatedActivity> delegations) {
        if (CollectionUtils.isEmpty(delegations)) {
            return "";
        }
        String delegationsString = delegations.stream().map(delegation -> {
            String delegatedUser = WordTemplateActivityHistoryWrapper.getRealUserName(delegation.getUserId());
            return delegation.getTransferType().getTanslatedShortName() + delegatedUser;
        }).collect(Collectors.joining(", "));
        return " (" + delegationsString + ")";
    }

    private static String getRealUserName(String sUserName) {
        try {
            UserInfo user = UserInfoCache.get().get(sUserName);
            if (user == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)user.getFullName())) {
                return sUserName;
            }
            return user.getFullName();
        }
        catch (Exception e) {
            return sUserName;
        }
    }
}

