/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.plusmpm.database.hibernate.query.SimpleQuery;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.json.JSONArray;
import org.json.JSONObject;

public class SearchDocsInArchive
extends HttpServlet {
    public static Logger log = Logger.getLogger(SearchDocsInArchive.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* SearchDocsInArchive Servlet ****************************");
        PrintWriter printWriter = null;
        JSONArray documents = null;
        JSONObject answer = null;
        GsonCustomUtils gsonCustomUtils = null;
        List conditions = null;
        DocClassTable docClassTable = null;
        IndexTable indexTable = null;
        DBManagement dbm = new DBManagement();
        String docClassId = "";
        HashMap<Object, Object> scalars = null;
        SimpleQuery simpleQuery = null;
        List resultList = null;
        SimpleDateFormat sdfsmall = new SimpleDateFormat("yyyy-MM-dd");
        String columnNamePrefix = "idx000";
        Object indecesTable = "";
        Object query = "";
        String andSql = " and ";
        String whereSql = " where ";
        int iAllResultsSize = 0;
        ArrayList indexesDefs = null;
        try {
            gsonCustomUtils = new GsonCustomUtils();
            documents = new JSONArray();
            String docClassName = request.getParameter("docClassName");
            String cond = request.getParameter("conditions");
            Object sortBy = request.getParameter("sortBy");
            String sortDir = request.getParameter("sortDir");
            String start = request.getParameter("start");
            String limit = request.getParameter("limit");
            int iOffset = 0;
            int iLimit = 0;
            if (Tools.isNullOrEmpty((String)docClassName)) {
                throw new CUFException("Brak klasy dokumentow");
            }
            docClassTable = dbm.getDocClassByName(docClassName);
            if (docClassTable == null) {
                throw new CUFException("Klasa dokumentow o nazwie " + docClassName + " nie istnieje w systemie");
            }
            docClassId = docClassTable.getId().toString();
            indecesTable = "pm_idx000" + docClassId;
            query = "SELECT itab.* FROM " + (String)indecesTable + " as itab" + whereSql;
            if (Tools.isNullOrEmpty((String)cond)) {
                throw new CUFException("Brak warunkow wyszukiwania dokumentow w klasie " + docClassName);
            }
            if (Tools.isNullOrEmpty((String)sortBy)) {
                sortBy = "fileid";
                sortDir = "asc";
            } else {
                IndexTable idx = dbm.getIndexByNameInDocClass(docClassId, (String)sortBy);
                if (idx == null) {
                    sortBy = "fileid";
                    sortDir = "asc";
                } else {
                    sortBy = "idx000" + idx.getId().toString();
                }
            }
            if (Tools.isNullOrEmpty((String)sortDir)) {
                sortDir = "asc";
            } else if (!sortDir.equalsIgnoreCase("asc") && !sortDir.equalsIgnoreCase("desc")) {
                sortDir = "asc";
            }
            iOffset = Integer.parseInt(start);
            iLimit = Integer.parseInt(limit);
            indexesDefs = new ArrayList();
            scalars = new HashMap<Object, Object>();
            scalars.put("fileid", StandardBasicTypes.LONG);
            conditions = gsonCustomUtils.getMapDataForExtJsonStore(cond);
            for (Map condition : conditions) {
                String indexName = (String)condition.get("indexName");
                Object indexValue = (String)condition.get("indexValue");
                String indexType = "";
                String indexId = "";
                indexTable = dbm.getIndexByNameInDocClass(docClassId, indexName);
                if (indexTable == null) continue;
                indexType = indexTable.getIndexType();
                indexId = indexTable.getId().toString();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", columnNamePrefix + indexId);
                hashMap.put("name", indexName);
                hashMap.put("type", indexType);
                indexesDefs.add(hashMap);
                if (indexType.equalsIgnoreCase("string") || indexType.equalsIgnoreCase("list")) {
                    scalars.put(columnNamePrefix + indexId, StandardBasicTypes.STRING);
                } else if (indexType.equalsIgnoreCase("float")) {
                    scalars.put(columnNamePrefix + indexId, StandardBasicTypes.DOUBLE);
                } else if (indexType.equalsIgnoreCase("integer")) {
                    scalars.put(columnNamePrefix + indexId, StandardBasicTypes.LONG);
                } else if (indexType.equalsIgnoreCase("date")) {
                    scalars.put(columnNamePrefix + indexId, StandardBasicTypes.TIMESTAMP);
                }
                if (Tools.isNullOrEmpty((String)indexValue)) continue;
                if (indexType.equalsIgnoreCase("date")) {
                    String startDate = (String)condition.get("startDate");
                    String endDate = (String)condition.get("endDate");
                    if (Tools.isNullOrEmpty((String)startDate) && Tools.isNullOrEmpty((String)endDate)) continue;
                    if (Tools.isNullOrEmpty((String)startDate)) {
                        query = (String)query + columnNamePrefix + indexId + " <= '" + endDate + "' " + andSql;
                        continue;
                    }
                    if (Tools.isNullOrEmpty((String)endDate)) {
                        query = (String)query + columnNamePrefix + indexId + " >= '" + startDate + "' " + andSql;
                        continue;
                    }
                    query = (String)query + columnNamePrefix + indexId + " between '" + startDate + "' and '" + endDate + "' " + andSql;
                    continue;
                }
                if (indexType.equalsIgnoreCase("string") || indexType.equalsIgnoreCase("list")) {
                    indexValue = ((String)indexValue).replaceAll("\\\\", "\\\\\\\\");
                    indexValue = "*" + (String)indexValue + "*";
                    query = SearchDocsInArchive.creatWhereStatement((String)query, columnNamePrefix + indexId, (String)indexValue, true) + andSql;
                    continue;
                }
                if (!indexType.equalsIgnoreCase("integer") && !indexType.equalsIgnoreCase("float")) continue;
                query = (String)query + columnNamePrefix + indexId + " = '" + (String)indexValue + "'" + andSql;
            }
            if (((String)query).endsWith(andSql)) {
                query = ((String)query).substring(0, ((String)query).length() - andSql.length());
            }
            if (((String)query).endsWith(whereSql)) {
                query = ((String)query).substring(0, ((String)query).length() - whereSql.length());
            }
            query = (String)query + " order by " + (String)sortBy + " " + sortDir;
            log.info((Object)("Zapytanie: " + (String)query));
            simpleQuery = new SimpleQuery((String)query, scalars);
            resultList = simpleQuery.list(0, 0);
            if (resultList != null) {
                iAllResultsSize = resultList.size();
                if (iLimit == 0) {
                    iLimit = iAllResultsSize;
                }
                for (int i = iOffset; i < iOffset + iLimit && i < iAllResultsSize; ++i) {
                    Map resultRow = (Map)resultList.get(i);
                    JSONObject oneDoc = new JSONObject();
                    long fileId = (Long)resultRow.get("fileid");
                    oneDoc.put("fileId", (Object)String.valueOf(fileId));
                    for (Map map : indexesDefs) {
                        String id = (String)map.get("id");
                        String name = (String)map.get("name");
                        String type = (String)map.get("type");
                        String archiveValue = "";
                        Object value = resultRow.get(id);
                        if (type.equalsIgnoreCase("string") || type.equalsIgnoreCase("list")) {
                            archiveValue = value != null ? (String)value : "";
                        } else if (type.equalsIgnoreCase("float")) {
                            archiveValue = value != null ? ((Double)value).toString() : "";
                        } else if (type.equalsIgnoreCase("integer")) {
                            archiveValue = value != null ? ((Long)value).toString() : "";
                        } else if (type.equalsIgnoreCase("date")) {
                            archiveValue = value != null ? sdfsmall.format((Date)value) : "";
                        }
                        oneDoc.put(name, (Object)archiveValue);
                    }
                    documents.put((Object)oneDoc);
                }
            }
            log.info((Object)("Wyszukwano " + iAllResultsSize + " dokumentow w klasie " + docClassName + " na podstawie podanych warunkow wyszukiwania"));
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                answer = new JSONObject();
                answer.put("documents", (Object)documents);
                answer.put("total", iAllResultsSize);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(answer);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private static String creatWhereStatement(String sQuerry, String sFieldName, String sValue, boolean bUpperCase) {
        if (sValue == null) {
            sValue = "";
        }
        if (sValue.compareToIgnoreCase("") != 0) {
            if (sValue.contains(";")) {
                String[] asValues = sValue.split(";");
                StringBuilder sbOrQuery = new StringBuilder();
                for (int i = 0; i < asValues.length; ++i) {
                    boolean bLikeQuery = false;
                    if (asValues[i].indexOf("*") != -1 || asValues[i].indexOf("%") != -1) {
                        if (asValues[i].matches(".*\\\\.*")) {
                            asValues[i] = asValues[i].replaceAll("\\\\", "\\\\\\\\");
                        }
                        bLikeQuery = true;
                        asValues[i] = asValues[i].replace('*', '%');
                    }
                    if (sbOrQuery.length() > 0) {
                        sbOrQuery.append(" OR ");
                    }
                    if (!Tools.isNullOrEmpty((String)sFieldName) && sFieldName.compareToIgnoreCase("processdefinitions.processdefinitionid") != 0) {
                        sbOrQuery.append(" ( ");
                        if (bUpperCase) {
                            sbOrQuery.append(NativeDatabase.getImplementation().getCaseInsensitiveComparisonQueryPart(sFieldName));
                        } else {
                            sbOrQuery.append(sFieldName);
                        }
                        if (bLikeQuery) {
                            sbOrQuery.append(" LIKE ");
                        } else {
                            sbOrQuery.append(" = ");
                        }
                        if (bUpperCase) {
                            sbOrQuery.append(NativeDatabase.getImplementation().getCaseInsensitiveComparisonQueryPart("'" + asValues[i] + "'"));
                        } else {
                            sbOrQuery.append("'" + asValues[i] + "'");
                        }
                        sbOrQuery.append(" ) ");
                        continue;
                    }
                    sbOrQuery.append(" ( ");
                    sbOrQuery.append(sFieldName);
                    if (bLikeQuery) {
                        sbOrQuery.append(" LIKE ");
                    } else {
                        sbOrQuery.append(" = ");
                    }
                    sbOrQuery.append("'" + asValues[i] + "'");
                    sbOrQuery.append(" ) ");
                }
                sQuerry = (String)sQuerry + "( " + sbOrQuery.toString() + " ) ";
            } else if (sValue.indexOf("*") != -1 || sValue.indexOf("%") != -1) {
                if (sValue.matches(".*\\\\.*")) {
                    sValue = sValue.replaceAll("\\\\", "\\\\\\\\");
                }
                sValue = sValue.replace('*', '%');
                sQuerry = !Tools.isNullOrEmpty((String)sFieldName) && sFieldName.compareToIgnoreCase("processdefinitions.processdefinitionid") != 0 ? (bUpperCase ? (String)sQuerry + NativeDatabase.getImplementation().getCaseInsensitiveComparisonQueryPart(sFieldName) + " LIKE " + NativeDatabase.getImplementation().getCaseInsensitiveComparisonQueryPart("'" + sValue + "'") : (String)sQuerry + sFieldName + " LIKE '" + sValue + "'") : (String)sQuerry + sFieldName + " LIKE '" + sValue + "'";
            } else {
                sQuerry = !Tools.isNullOrEmpty((String)sFieldName) && sFieldName.compareToIgnoreCase("processdefinitions.processdefinitionid") != 0 ? (bUpperCase ? (String)sQuerry + NativeDatabase.getImplementation().getCaseInsensitiveComparisonQueryPart(sFieldName) + " = " + NativeDatabase.getImplementation().getCaseInsensitiveComparisonQueryPart("'" + sValue + "'") : (String)sQuerry + sFieldName + " = '" + sValue + "'") : (String)sQuerry + sFieldName + " LIKE '" + sValue + "'";
            }
        }
        return sQuerry;
    }
}

