/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.util.Date;
import java.util.List;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

@Deprecated(since="4.2", forRemoval=true)
public class ExportDirectories
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportDirectories.class);

    @AdvancedTask(name="ExportDirectoriesToXLS", description="ExportDirectoriesToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportDirectoriesToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportDirectoriesToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        DBManagement dbm = new DBManagement();
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        List directories = null;
        int colPos = 0;
        int rowPos = 0;
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet directoriesSheet = workbook.createSheet("Katalogi", 0);
            log.info((Object)"Utworzono arkusz do eksportu katalogow");
            String[] colIDs = new String[]{"Nazwa katalogu", "Katalog nadrz\u0119dny", "Rozmiar [MB]", "Pr\u00f3g przepe\u0142nienia [%]", "Nazwa urz\u0105dzenia"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (int i = 0; i < colIDs.length; ++i) {
                CUFTools.addCellToXLSSheet(directoriesSheet, colPos, 0, colIDs[i], times12format, cellView);
                ++colPos;
            }
            log.info((Object)"Utworzono naglowki w arkuszu");
            log.info((Object)"Pobieranie katalogow z systemu");
            directories = as.getAllDirectories(new String[0]);
            if (directories != null && directories.size() > 0) {
                for (Directory oneDir : directories) {
                    Device dirDeviceTable;
                    Directory rootDirTable;
                    if (oneDir == null) continue;
                    colPos = 0;
                    ++rowPos;
                    String dirName = oneDir.getDirectoryName();
                    Long rootDirId = oneDir.getRootDir().getId();
                    String rootDirName = "";
                    Long lDirSize = oneDir.getDirectorySize();
                    String dirSize = "";
                    Long lDirTreshold = oneDir.getDirectoryThreshold();
                    String dirTreshold = "";
                    Long dirDeviceId = oneDir.getDevice().getId();
                    String dirDeviceName = "";
                    log.info((Object)("Eksportowanie danych o katalogu " + dirName));
                    CUFTools.addCellToXLSSheet(directoriesSheet, colPos, rowPos, dirName, null, cellView);
                    rootDirName = rootDirId != null ? (rootDirId == 0L ? "brak" : ((rootDirTable = as.getDirectory(rootDirId, new String[0])) != null ? rootDirTable.getDirectoryName() : "brak")) : "brak";
                    CUFTools.addCellToXLSSheet(directoriesSheet, ++colPos, rowPos, rootDirName, null, cellView);
                    ++colPos;
                    if (lDirSize != null) {
                        dirSize = String.valueOf(lDirSize);
                    }
                    CUFTools.addCellToXLSSheet(directoriesSheet, colPos, rowPos, dirSize, null, cellView);
                    ++colPos;
                    if (lDirTreshold != null) {
                        dirTreshold = String.valueOf(lDirTreshold);
                    }
                    CUFTools.addCellToXLSSheet(directoriesSheet, colPos, rowPos, dirTreshold, null, cellView);
                    ++colPos;
                    if (dirDeviceId != null && (dirDeviceTable = as.getDeviceById(dirDeviceId, new String[0])) != null) {
                        dirDeviceName = dirDeviceTable.getDeviceName();
                    }
                    CUFTools.addCellToXLSSheet(directoriesSheet, colPos, rowPos, dirDeviceName, null, cellView);
                    ++colPos;
                }
            } else {
                log.info((Object)"Brak katalogow zdefiniowanych w systemie");
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport katalogow do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania klas i zestawow dokumentow. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportDirectoriesToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

