/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.web.controller.template;

import com.plusmpm.util.HttpHeaders;
import com.suncode.cuf.template.WordTemplateService;
import com.suncode.cuf.util.TemporaryFile;
import com.suncode.cuf.util.template.WordTemplateUtil;
import com.suncode.cuf.web.dto.template.DocumentInfo;
import com.suncode.cuf.web.dto.template.WordTemplateForm;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cuf/template/word"})
public class WordTemplateController {
    @Autowired
    private WordTemplateService wordTemplateService;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public DocumentInfo generate(WordTemplateForm config) throws Exception {
        String documentName = config.getDocumentName().replaceAll("/", "_").replaceAll("\\\\", "_").replace(":", "_");
        return this.wordTemplateService.generateAndAttach(config);
    }

    @RequestMapping(value={"/generate-document-uuid"}, method={RequestMethod.POST})
    @ResponseBody
    public String generateDocumentUUID(WordTemplateForm config) throws IOException {
        return this.wordTemplateService.generateDocumentUUID(config);
    }

    @RequestMapping(value={"/preview/{uuid}"}, method={RequestMethod.GET})
    public void preview(@PathVariable String uuid, HttpServletResponse response) throws IOException {
        InputStream stream = this.wordTemplateService.getTemporaryDocument(uuid);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(stream);
        response.setHeader("Content-Disposition", HttpHeaders.getContentDisposition((String)"dokument.pdf", (boolean)true));
        response.setHeader("Cache-Control", "no-cache, must-revalidate, max-age=0");
        response.setContentLength(bufferedInputStream.available());
        response.setContentType("application/pdf");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        IOUtils.write((byte[])IOUtils.toByteArray((InputStream)bufferedInputStream), (OutputStream)servletOutputStream);
        servletOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    @ResponseBody
    public void download(WordTemplateForm config, HttpServletResponse response) throws Exception {
        File document = TemporaryFile.create(config.getTemplate(), "");
        try {
            this.generateDocument(document, config);
            if (config.isAttachToArchive() || config.isAttachToProcess()) {
                WordTemplateUtil.archiveAndAttachToProcess(document, config.getProcessId(), config.getActivityId(), config.getDocumentClass(), config.getTemplate(), config.getFormat(), config.isAttachToProcess(), config.isNewVersion(), config.getDocumentName(), config.getDescription(), config.getIndexes());
            }
            Object fileName = StringUtils.isBlank((CharSequence)config.getDocumentName()) ? WordTemplateUtil.getFileName(config.getProcessId(), config.getTemplate(), config.getFormat()) : config.getDocumentName() + "." + config.getFormat().toString().toLowerCase();
            this.writeFile(document, (String)fileName, response);
        }
        finally {
            FileUtils.deleteQuietly((File)document);
        }
    }

    private void generateDocument(File f, WordTemplateForm config) {
        this.wordTemplateService.generateForProcess(f, config.getTemplate(), config.getProcessId(), config.getMappings(), config.getFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, String name, HttpServletResponse response) throws Exception {
        FileInputStream input = new FileInputStream(file);
        try {
            response.setContentLength((int)file.length());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
            IOUtils.copy((InputStream)input, (OutputStream)response.getOutputStream());
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }
}

